/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import io.crate.analyze.user.Privilege;
import io.crate.auth.user.UserPrivileges;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.user.SecureHash;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class User {
    public static final User CRATE_USER = new User("crate", EnumSet.of(Role.SUPERUSER), Set.of(), null);
    private final String name;
    private final Set<Role> roles;
    private final UserPrivileges privileges;
    @Nullable
    private final SecureHash password;

    User(String name, Set<Role> roles, Set<Privilege> privileges, @Nullable SecureHash password) {
        this.roles = roles;
        this.name = name;
        this.privileges = new UserPrivileges(privileges);
        this.password = password;
    }

    public static User of(String name) {
        return new User(name, Set.of(), Set.of(), null);
    }

    public static User of(String name, @Nullable Set<Privilege> privileges, SecureHash password) {
        return new User(name, Set.of(), privileges == null ? Set.of() : privileges, password);
    }

    @VisibleForTesting
    public static User of(String name, EnumSet<Role> roles) {
        return new User(name, roles, Set.of(), null);
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public SecureHash password() {
        return this.password;
    }

    public boolean isSuperUser() {
        return this.roles.contains((Object)Role.SUPERUSER);
    }

    public Iterable<Privilege> privileges() {
        return this.privileges;
    }

    public boolean hasPrivilege(Privilege.Type type, Privilege.Clazz clazz, @Nullable String ident, String defaultSchema) {
        return this.isSuperUser() || this.privileges.matchPrivilege(type, clazz, ident, defaultSchema);
    }

    public boolean hasAnyPrivilege(Privilege.Clazz clazz, @Nullable String ident) {
        return this.isSuperUser() || this.privileges.matchPrivilegeOfAnyType(clazz, ident);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User that = (User)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.roles, that.roles) && Objects.equals(this.privileges, that.privileges);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.roles, this.privileges);
    }

    public String toString() {
        return "User{" + this.name + "}";
    }

    public static enum Role {
        SUPERUSER;

    }
}

