/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import io.crate.settings.CrateSetting;
import io.crate.types.DataTypes;
import io.netty.handler.ssl.ClientAuth;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public final class AuthSettings {
    public static final CrateSetting<Boolean> AUTH_HOST_BASED_ENABLED_SETTING = CrateSetting.of(Setting.boolSetting("auth.host_based.enabled", false, Setting.Property.NodeScope), DataTypes.BOOLEAN);
    public static final CrateSetting<Settings> AUTH_HOST_BASED_CONFIG_SETTING = CrateSetting.of(Setting.groupSetting("auth.host_based.config.", Setting.Property.NodeScope), DataTypes.UNTYPED_OBJECT);
    public static final CrateSetting<String> AUTH_TRUST_HTTP_DEFAULT_HEADER = CrateSetting.of(new Setting("auth.trust.http_default_user", "crate", Function.identity(), Setting.Property.NodeScope), DataTypes.STRING);
    public static final String HTTP_HEADER_REAL_IP = "X-Real-Ip";

    private AuthSettings() {
    }

    public static ClientAuth resolveClientAuth(Settings settings) {
        Settings hbaSettings = AUTH_HOST_BASED_CONFIG_SETTING.setting().get(settings);
        int numMethods = 0;
        int numCertMethods = 0;
        for (Map.Entry<String, Settings> entry : hbaSettings.getAsGroups().entrySet()) {
            Settings entrySettings = entry.getValue();
            String method = entrySettings.get("method", "trust");
            ++numMethods;
            if (!method.equals("cert")) continue;
            ++numCertMethods;
        }
        if (numCertMethods == 0) {
            return ClientAuth.NONE;
        }
        return numCertMethods == numMethods ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL;
    }
}

