/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.where;

import com.google.common.collect.Iterables;
import io.crate.analyze.ScalarsAndRefsToTrue;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.common.StringUtils;
import io.crate.common.collections.Lists2;
import io.crate.common.collections.Tuple;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.reference.partitioned.PartitionExpression;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.PartitionReferenceResolver;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocTableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class WhereClauseAnalyzer {
    public static WhereClause resolvePartitions(WhereClause where, AbstractTableRelation<?> tableRelation, CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx) {
        if (!where.hasQuery() || !(tableRelation instanceof DocTableRelation) || where.query().equals(Literal.BOOLEAN_TRUE)) {
            return where;
        }
        DocTableInfo table = (DocTableInfo)((DocTableRelation)tableRelation).tableInfo();
        if (!table.isPartitioned()) {
            return where;
        }
        if (table.partitions().isEmpty()) {
            return WhereClause.NO_MATCH;
        }
        PartitionResult partitionResult = WhereClauseAnalyzer.resolvePartitions(where.queryOrFallback(), table, coordinatorTxnCtx, nodeCtx);
        if (!(where.partitions().isEmpty() || partitionResult.partitions.isEmpty() || partitionResult.partitions.equals(where.partitions()))) {
            throw new IllegalArgumentException("Given partition ident does not match partition evaluated from where clause");
        }
        return new WhereClause(partitionResult.query, partitionResult.partitions, where.clusteredBy());
    }

    private static PartitionReferenceResolver preparePartitionResolver(List<Reference> partitionColumns) {
        ArrayList<PartitionExpression> partitionExpressions = new ArrayList<PartitionExpression>(partitionColumns.size());
        int idx = 0;
        for (Reference partitionedByColumn : partitionColumns) {
            partitionExpressions.add(new PartitionExpression(partitionedByColumn, idx));
            ++idx;
        }
        return new PartitionReferenceResolver(partitionExpressions);
    }

    public static PartitionResult resolvePartitions(Symbol query, DocTableInfo tableInfo, CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx) {
        assert (tableInfo.isPartitioned()) : "table must be partitioned in order to resolve partitions";
        assert (!tableInfo.partitions().isEmpty()) : "table must have at least one partition";
        PartitionReferenceResolver partitionReferenceResolver = WhereClauseAnalyzer.preparePartitionResolver(tableInfo.partitionedByColumns());
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(nodeCtx, RowGranularity.PARTITION, partitionReferenceResolver, null);
        HashMap<Symbol, List<Literal>> queryPartitionMap = new HashMap<Symbol, List<Literal>>();
        for (PartitionName partitionName : tableInfo.partitions()) {
            for (PartitionExpression partitionExpression : partitionReferenceResolver.expressions()) {
                partitionExpression.setNextRow(partitionName);
            }
            Symbol normalized = normalizer.normalize(query, coordinatorTxnCtx);
            assert (normalized != null) : "normalizing a query must not return null";
            if (normalized.equals(query)) {
                return new PartitionResult(query, Collections.emptyList());
            }
            boolean canMatch = WhereClause.canMatch(normalized);
            if (!canMatch) continue;
            ArrayList<Literal<String>> partitions = (ArrayList<Literal<String>>)queryPartitionMap.get(normalized);
            if (partitions == null) {
                partitions = new ArrayList<Literal<String>>();
                queryPartitionMap.put(normalized, partitions);
            }
            partitions.add(Literal.of(partitionName.asIndexName()));
        }
        if (queryPartitionMap.size() == 1) {
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(queryPartitionMap.entrySet());
            return new PartitionResult((Symbol)entry.getKey(), Lists2.map((Collection)entry.getValue(), literal -> StringUtils.nullOrString(literal.value())));
        }
        if (queryPartitionMap.size() > 0) {
            PartitionResult partitionResult = WhereClauseAnalyzer.tieBreakPartitionQueries(normalizer, queryPartitionMap, coordinatorTxnCtx);
            return partitionResult == null ? new PartitionResult(query, Lists2.map(tableInfo.partitions(), PartitionName::asIndexName)) : partitionResult;
        }
        return new PartitionResult(Literal.BOOLEAN_FALSE, Collections.emptyList());
    }

    @Nullable
    private static PartitionResult tieBreakPartitionQueries(EvaluatingNormalizer normalizer, Map<Symbol, List<Literal>> queryPartitionMap, CoordinatorTxnCtx coordinatorTxnCtx) throws UnsupportedOperationException {
        ArrayList<Tuple<Symbol, List<Literal>>> canMatch = new ArrayList<Tuple<Symbol, List<Literal>>>();
        for (Map.Entry<Symbol, List<Literal>> entry : queryPartitionMap.entrySet()) {
            Symbol query = entry.getKey();
            List<Literal> partitions = entry.getValue();
            Symbol normalized = normalizer.normalize(ScalarsAndRefsToTrue.rewrite(query), coordinatorTxnCtx);
            assert (normalized instanceof Literal) : "after normalization and replacing all reference occurrences with true there must only be a literal left";
            Object value = ((Literal)normalized).value();
            if (value == null || !((Boolean)value).booleanValue()) continue;
            canMatch.add(new Tuple<Symbol, List<Literal>>(query, partitions));
        }
        if (canMatch.size() == 1) {
            Tuple symbolListTuple = (Tuple)canMatch.get(0);
            return new PartitionResult((Symbol)symbolListTuple.v1(), Lists2.map((Collection)symbolListTuple.v2(), literal -> StringUtils.nullOrString(literal.value())));
        }
        return null;
    }

    public static class PartitionResult {
        public final Symbol query;
        public final List<String> partitions;

        PartitionResult(Symbol query, List<String> partitions) {
            this.query = query;
            this.partitions = partitions;
        }
    }
}

