/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.where;

import com.google.common.collect.Sets;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.operator.EqOperator;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.Operators;
import io.crate.expression.operator.any.AnyOperators;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamOutput;

public class EqualityExtractor {
    private static final Function NULL_MARKER = new Function(Signature.scalar("null_marker", DataTypes.UNDEFINED.getTypeSignature()), List.of(), DataTypes.UNDEFINED);
    private static final EqProxy NULL_MARKER_PROXY = new EqProxy(NULL_MARKER);
    private EvaluatingNormalizer normalizer;

    public EqualityExtractor(EvaluatingNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    public List<List<Symbol>> extractParentMatches(List<ColumnIdent> columns, Symbol symbol, @Nullable TransactionContext coordinatorTxnCtx) {
        return this.extractMatches(columns, symbol, false, coordinatorTxnCtx);
    }

    @Nullable
    public List<List<Symbol>> extractExactMatches(List<ColumnIdent> columns, Symbol symbol, @Nullable TransactionContext transactionContext) {
        return this.extractMatches(columns, symbol, true, transactionContext);
    }

    @Nullable
    private List<List<Symbol>> extractMatches(Collection<ColumnIdent> columns, Symbol symbol, boolean exact, @Nullable TransactionContext transactionContext) {
        ProxyInjectingVisitor.Context context = new ProxyInjectingVisitor.Context(columns, exact);
        Symbol proxiedTree = symbol.accept(ProxyInjectingVisitor.INSTANCE, context);
        if (context.exact && context.seenUnknown) {
            return null;
        }
        List<Set<EqProxy>> comparisons = context.comparisonSet();
        Set cp = Sets.cartesianProduct(comparisons);
        ArrayList<List<Symbol>> result = new ArrayList<List<Symbol>>();
        for (List proxies : cp) {
            boolean anyNull = false;
            for (EqProxy proxy : proxies) {
                if (proxy != NULL_MARKER_PROXY) {
                    proxy.setTrue();
                    continue;
                }
                anyNull = true;
            }
            Symbol normalized = this.normalizer.normalize(proxiedTree, transactionContext);
            if (normalized == Literal.BOOLEAN_TRUE) {
                if (anyNull) {
                    return null;
                }
                if (proxies.isEmpty()) continue;
                ArrayList<Symbol> row = new ArrayList<Symbol>(proxies.size());
                for (EqProxy proxy : proxies) {
                    proxy.reset();
                    row.add(proxy.origin.arguments().get(1));
                }
                result.add(row);
                continue;
            }
            for (EqProxy proxy : proxies) {
                proxy.reset();
            }
        }
        return result.isEmpty() ? null : result;
    }

    static class ProxyInjectingVisitor
    extends SymbolVisitor<Context, Symbol> {
        public static final ProxyInjectingVisitor INSTANCE = new ProxyInjectingVisitor();

        private ProxyInjectingVisitor() {
        }

        @Override
        protected Symbol visitSymbol(Symbol symbol, Context context) {
            return symbol;
        }

        @Override
        public Symbol visitMatchPredicate(MatchPredicate matchPredicate, Context context) {
            context.seenUnknown = true;
            return Literal.BOOLEAN_TRUE;
        }

        @Override
        public Symbol visitReference(Reference symbol, Context context) {
            if (!context.comparisons.containsKey(symbol.column())) {
                context.seenUnknown = true;
            }
            return (Symbol)super.visitReference(symbol, context);
        }

        @Override
        public Symbol visitFunction(Function function, Context context) {
            String functionName = function.name();
            List<Symbol> arguments = function.arguments();
            Symbol firstArg = arguments.get(0);
            if (functionName.equals("op_=")) {
                Comparison comparison;
                if ((firstArg = Symbols.unwrapReferenceFromCast(firstArg)) instanceof Reference && !SymbolVisitors.any(Symbols.IS_COLUMN, arguments.get(1)) && (comparison = context.comparisons.get(((Reference)firstArg).column())) != null) {
                    context.proxyBelow = true;
                    return comparison.add(function);
                }
            } else if (functionName.equals(AnyOperators.Type.EQ.opName()) && arguments.get(1).symbolType().isValueSymbol()) {
                Reference reference;
                Comparison comparison;
                if ((firstArg = Symbols.unwrapReferenceFromCast(firstArg)) instanceof Reference && (comparison = context.comparisons.get((reference = (Reference)firstArg).column())) != null) {
                    context.proxyBelow = true;
                    return comparison.add(function);
                }
            } else if (Operators.LOGICAL_OPERATORS.contains(functionName)) {
                boolean proxyBelowPre;
                boolean proxyBelowPost = proxyBelowPre = context.proxyBelow;
                context.ignoreUnknown = context.ignoreUnknown || functionName.equals("op_and");
                ArrayList<Symbol> newArgs = new ArrayList<Symbol>(arguments.size());
                for (Symbol arg : arguments) {
                    context.proxyBelow = proxyBelowPre;
                    newArgs.add(arg.accept(this, context));
                    proxyBelowPost = context.proxyBelow || proxyBelowPost;
                }
                context.proxyBelow = proxyBelowPost;
                if (!context.proxyBelow && function.valueType().equals(DataTypes.BOOLEAN)) {
                    return Literal.BOOLEAN_TRUE;
                }
                return new Function(function.signature(), newArgs, function.valueType());
            }
            if (!context.ignoreUnknown || functionName.equals("match")) {
                context.seenUnknown = true;
            }
            return Literal.BOOLEAN_TRUE;
        }

        static class Context {
            private LinkedHashMap<ColumnIdent, Comparison> comparisons;
            private boolean proxyBelow;
            private boolean seenUnknown = false;
            private boolean ignoreUnknown = false;
            private final boolean exact;

            private Context(Collection<ColumnIdent> references, boolean exact) {
                this.exact = exact;
                this.comparisons = new LinkedHashMap(references.size());
                for (ColumnIdent reference : references) {
                    this.comparisons.put(reference, new Comparison());
                }
            }

            private List<Set<EqProxy>> comparisonSet() {
                ArrayList<Set<EqProxy>> comps = new ArrayList<Set<EqProxy>>(this.comparisons.size());
                for (Comparison comparison : this.comparisons.values()) {
                    comps.add(new HashSet<EqProxy>(comparison.proxies.values()));
                }
                return comps;
            }
        }

        static class Comparison {
            final HashMap<Function, EqProxy> proxies = new HashMap();

            public Comparison() {
                this.proxies.put(NULL_MARKER, NULL_MARKER_PROXY);
            }

            public EqProxy add(Function compared) {
                if (compared.name().equals(AnyOperators.Type.EQ.opName())) {
                    AnyEqProxy anyEqProxy = new AnyEqProxy(compared, this.proxies);
                    for (EqProxy proxiedProxy : anyEqProxy) {
                        if (this.proxies.containsKey(proxiedProxy.origin())) continue;
                        this.proxies.put(proxiedProxy.origin(), proxiedProxy);
                    }
                    return anyEqProxy;
                }
                EqProxy proxy = this.proxies.get(compared);
                if (proxy == null) {
                    proxy = new EqProxy(compared);
                    this.proxies.put(compared, proxy);
                }
                return proxy;
            }
        }
    }

    static class EqProxy
    extends Symbol {
        protected Symbol current;
        protected final Function origin;

        private Function origin() {
            return this.origin;
        }

        EqProxy(Function origin) {
            this.origin = origin;
            this.current = origin;
        }

        public void reset() {
            this.current = this.origin;
        }

        public void setTrue() {
            this.current = Literal.BOOLEAN_TRUE;
        }

        @Override
        public SymbolType symbolType() {
            return this.current.symbolType();
        }

        @Override
        public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
            return this.current.accept(visitor, context);
        }

        public DataType valueType() {
            return this.current.valueType();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException("writeTo not supported for " + EqProxy.class.getSimpleName());
        }

        public String forDisplay() {
            if (this == NULL_MARKER_PROXY) {
                return "NULL";
            }
            String s = "(" + ((Reference)this.origin.arguments().get(0)).column().fqn() + "=" + ((Literal)this.origin.arguments().get(1)).value() + ")";
            if (this.current != this.origin) {
                s = s + " TRUE";
            }
            return s;
        }

        @Override
        public String toString(Style style) {
            if (this == NULL_MARKER_PROXY) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder().append("(").append(this.origin.arguments().get(0).toString(style)).append("=").append(this.origin.arguments().get(1).toString(style)).append(")");
            if (this.current != this.origin) {
                sb.append(" TRUE");
            }
            return sb.toString();
        }
    }

    private static class AnyEqProxy
    extends EqProxy
    implements Iterable<EqProxy> {
        private Map<Function, EqProxy> proxies;
        @Nullable
        private ChildEqProxy delegate = null;

        private AnyEqProxy(Function compared, Map<Function, EqProxy> existingProxies) {
            super(compared);
            this.initProxies(existingProxies);
        }

        private void initProxies(Map<Function, EqProxy> existingProxies) {
            Symbol left = this.origin.arguments().get(0);
            Signature signature = this.origin.signature();
            assert (signature != null) : "Expecting non-null signature while analyzing";
            Literal arrayLiteral = (Literal)this.origin.arguments().get(1);
            this.proxies = new HashMap<Function, EqProxy>();
            for (Literal arrayElem : Literal.explodeCollection(arrayLiteral)) {
                Function f = new Function(EqOperator.SIGNATURE, Arrays.asList(left, arrayElem), Operator.RETURN_TYPE);
                EqProxy existingProxy = existingProxies.get(f);
                if (existingProxy == null) {
                    existingProxy = new ChildEqProxy(f, this);
                } else if (existingProxy instanceof ChildEqProxy) {
                    ((ChildEqProxy)existingProxy).addParent(this);
                }
                this.proxies.put(f, existingProxy);
            }
        }

        @Override
        public Iterator<EqProxy> iterator() {
            return this.proxies.values().iterator();
        }

        @Override
        public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
            if (this.delegate != null) {
                return this.delegate.accept(visitor, context);
            }
            return super.accept(visitor, context);
        }

        private void setDelegate(@Nullable ChildEqProxy childEqProxy) {
            this.delegate = childEqProxy;
        }

        private void cleanDelegate() {
            this.delegate = null;
        }

        private static class ChildEqProxy
        extends EqProxy {
            private List<AnyEqProxy> parentProxies = new ArrayList<AnyEqProxy>();

            private ChildEqProxy(Function origin, AnyEqProxy parent) {
                super(origin);
                this.addParent(parent);
            }

            private void addParent(AnyEqProxy parentProxy) {
                this.parentProxies.add(parentProxy);
            }

            @Override
            public void setTrue() {
                super.setTrue();
                for (AnyEqProxy parent : this.parentProxies) {
                    parent.setTrue();
                    parent.setDelegate(this);
                }
            }

            @Override
            public void reset() {
                super.reset();
                for (AnyEqProxy parent : this.parentProxies) {
                    parent.reset();
                    parent.cleanDelegate();
                }
            }
        }
    }
}

