/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.validator;

import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.types.DataTypes;
import java.util.Locale;

public class SemanticSortValidator {
    private static final InnerValidator INNER_VALIDATOR = new InnerValidator();

    public static void validate(Symbol symbol) throws UnsupportedOperationException {
        symbol.accept(INNER_VALIDATOR, new SortContext("ORDER BY"));
    }

    public static void validate(Symbol symbol, String operation) throws UnsupportedOperationException {
        symbol.accept(INNER_VALIDATOR, new SortContext(operation));
    }

    private static class InnerValidator
    extends SymbolVisitor<SortContext, Void> {
        private InnerValidator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitFunction(Function symbol, SortContext context) {
            if (!context.inFunction && !DataTypes.isPrimitive(symbol.valueType())) {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot %s '%s': invalid return type '%s'.", context.operation, symbol, symbol.valueType()));
            }
            try {
                context.inFunction = true;
                for (Symbol arg : symbol.arguments()) {
                    arg.accept(this, context);
                }
            }
            finally {
                context.inFunction = false;
            }
            return null;
        }

        @Override
        public Void visitMatchPredicate(MatchPredicate matchPredicate, SortContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "%s predicate cannot be used in an %s clause", "match", context.operation));
        }

        @Override
        public Void visitSymbol(Symbol symbol, SortContext context) {
            if (!context.inFunction && !DataTypes.isPrimitive(symbol.valueType())) {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot %s '%s': invalid data type '%s'.", context.operation, symbol, symbol.valueType()));
            }
            return null;
        }
    }

    static class SortContext {
        private final String operation;
        private boolean inFunction;

        SortContext(String operation) {
            this.operation = operation;
            this.inFunction = false;
        }
    }
}

