/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.user;

import io.crate.analyze.user.Privilege;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class PrivilegeIdent
implements Writeable {
    private final Privilege.Type type;
    private final Privilege.Clazz clazz;
    @Nullable
    private final String ident;

    public PrivilegeIdent(Privilege.Type type, Privilege.Clazz clazz, String ident) {
        this.type = type;
        this.clazz = clazz;
        this.ident = ident;
    }

    PrivilegeIdent(StreamInput in) throws IOException {
        this.type = Privilege.Type.VALUES.get(in.readInt());
        this.clazz = Privilege.Clazz.VALUES.get(in.readInt());
        this.ident = in.readOptionalString();
    }

    public Privilege.Type type() {
        return this.type;
    }

    public Privilege.Clazz clazz() {
        return this.clazz;
    }

    @Nullable
    public String ident() {
        return this.ident;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.type.ordinal());
        out.writeInt(this.clazz.ordinal());
        out.writeOptionalString(this.ident);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeIdent that = (PrivilegeIdent)o;
        return this.type == that.type && this.clazz == that.clazz && Objects.equals(this.ident, that.ident);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.clazz, this.ident});
    }
}

