/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.user;

import io.crate.analyze.user.PrivilegeIdent;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class Privilege
implements Writeable {
    private final State state;
    private final PrivilegeIdent ident;
    private final String grantor;

    public Privilege(State state, Type type, Clazz clazz, @Nullable String ident, String grantor) {
        this.state = state;
        this.ident = new PrivilegeIdent(type, clazz, ident);
        this.grantor = grantor;
    }

    public Privilege(StreamInput in) throws IOException {
        this.state = State.VALUES.get(in.readInt());
        this.ident = new PrivilegeIdent(in);
        this.grantor = in.readString();
    }

    public State state() {
        return this.state;
    }

    public PrivilegeIdent ident() {
        return this.ident;
    }

    public String grantor() {
        return this.grantor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Privilege privilege = (Privilege)o;
        return this.state == privilege.state && Objects.equals(this.ident, privilege.ident);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.ident});
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.state.ordinal());
        this.ident.writeTo(out);
        out.writeString(this.grantor);
    }

    public static enum State {
        GRANT,
        DENY,
        REVOKE;

        public static final List<State> VALUES;

        static {
            VALUES = List.of(State.values());
        }
    }

    public static enum Type {
        DQL,
        DML,
        DDL,
        AL;

        public static final List<Type> VALUES;

        static {
            VALUES = List.of(Type.values());
        }
    }

    public static enum Clazz {
        CLUSTER,
        SCHEMA,
        TABLE,
        VIEW;

        public static final List<Clazz> VALUES;

        static {
            VALUES = List.of(Clazz.values());
        }
    }
}

