/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.repositories;

import io.crate.sql.tree.GenericProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;

public class TypeSettings {
    private static final Map<String, Setting<?>> GENERIC = Map.of("max_restore_bytes_per_sec", Setting.byteSizeSetting("max_restore_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB), Setting.Property.NodeScope), "max_snapshot_bytes_per_sec", Setting.byteSizeSetting("max_snapshot_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB), Setting.Property.NodeScope));
    private final Map<String, Setting<?>> required;
    private final Map<String, Setting<?>> all;

    public TypeSettings(List<Setting<?>> required, List<Setting<?>> optional) {
        this(required.stream().collect(Collectors.toMap(Setting::getKey, Function.identity())), optional.stream().collect(Collectors.toMap(Setting::getKey, Function.identity())));
    }

    public TypeSettings(Map<String, Setting<?>> required, Map<String, Setting<?>> optional) {
        this.required = required;
        this.all = new HashMap(required.size() + optional.size() + GENERIC.size());
        this.all.putAll(required);
        this.all.putAll(optional);
        this.all.putAll(GENERIC);
    }

    public Map<String, Setting<?>> required() {
        return this.required;
    }

    public Map<String, Setting<?>> all() {
        return this.all;
    }

    public GenericProperties<?> dynamicProperties(GenericProperties<?> genericProperties) {
        return GenericProperties.empty();
    }
}

