/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.repositories;

import com.google.common.collect.Sets;
import io.crate.analyze.repositories.TypeSettings;
import io.crate.sql.tree.GenericProperties;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

@Singleton
public class RepositoryParamValidator {
    private final Map<String, TypeSettings> typeSettings;

    @Inject
    public RepositoryParamValidator(Map<String, TypeSettings> repositoryTypeSettings) {
        this.typeSettings = repositoryTypeSettings;
    }

    public void validate(String type, GenericProperties<?> genericProperties, Settings settings) {
        TypeSettings typeSettings = this.settingsForType(type);
        Map<String, Setting<?>> allSettings = typeSettings.all();
        GenericProperties<?> dynamicProperties = typeSettings.dynamicProperties(genericProperties);
        if (!dynamicProperties.isEmpty()) {
            allSettings = new HashMap(allSettings);
            for (String key : dynamicProperties.properties().keySet()) {
                allSettings.put(key, Setting.simpleString(key, new Setting.Property[0]));
            }
        }
        Set<String> names = settings.keySet();
        Sets.SetView missingRequiredSettings = Sets.difference(typeSettings.required().keySet(), names);
        if (!missingRequiredSettings.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The following required parameters are missing to create a repository of type \"%s\": [%s]", type, String.join((CharSequence)", ", (Iterable<? extends CharSequence>)missingRequiredSettings)));
        }
    }

    public TypeSettings settingsForType(String type) {
        TypeSettings typeSettings = this.typeSettings.get(type);
        if (typeSettings == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid repository type \"%s\"", type));
        }
        return typeSettings;
    }
}

