/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations.select;

import io.crate.analyze.OutputNameFormatter;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.select.SelectAnalysis;
import io.crate.analyze.validator.SelectSymbolValidator;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.sql.tree.AllColumns;
import io.crate.sql.tree.DefaultTraversalVisitor;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.SelectItem;
import io.crate.sql.tree.SingleColumn;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SelectAnalyzer {
    public static final InnerVisitor INSTANCE = new InnerVisitor();

    public static SelectAnalysis analyzeSelectItems(List<SelectItem> selectItems, Map<RelationName, AnalyzedRelation> sources, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext) {
        SelectAnalysis selectAnalysis = new SelectAnalysis(selectItems.size(), sources, expressionAnalyzer, expressionAnalysisContext);
        selectItems.forEach(x -> x.accept(INSTANCE, selectAnalysis));
        SelectSymbolValidator.validate(selectAnalysis.outputSymbols());
        return selectAnalysis;
    }

    private static class InnerVisitor
    extends DefaultTraversalVisitor<Void, SelectAnalysis> {
        private InnerVisitor() {
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, SelectAnalysis context) {
            Symbol symbol = context.toSymbol(node.getExpression());
            String alias = node.getAlias();
            if (alias != null) {
                context.add(new ColumnIdent(alias), new AliasSymbol(alias, symbol));
            } else {
                context.add(new ColumnIdent(OutputNameFormatter.format(node.getExpression())), symbol);
            }
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, SelectAnalysis context) {
            if (node.getPrefix().isPresent()) {
                QualifiedName prefix = node.getPrefix().get();
                AnalyzedRelation relation = context.sources().get(RelationName.of(prefix, null));
                if (relation != null) {
                    InnerVisitor.addAllFieldsFromRelation(context, relation);
                    return null;
                }
                int matches = 0;
                if (prefix.getParts().size() == 1) {
                    String prefixName = prefix.getParts().get(0);
                    for (Map.Entry<RelationName, AnalyzedRelation> entry : context.sources().entrySet()) {
                        RelationName relationName = entry.getKey();
                        if (relationName.schema() == null || !prefixName.equals(relationName.name())) continue;
                        InnerVisitor.addAllFieldsFromRelation(context, entry.getValue());
                        ++matches;
                    }
                }
                switch (matches) {
                    case 0: {
                        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The relation \"%s\" is not in the FROM clause.", prefix));
                    }
                    case 1: {
                        return null;
                    }
                }
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The referenced relation \"%s\" is ambiguous.", prefix));
            }
            for (AnalyzedRelation relation : context.sources().values()) {
                InnerVisitor.addAllFieldsFromRelation(context, relation);
            }
            return null;
        }

        private static void addAllFieldsFromRelation(SelectAnalysis context, AnalyzedRelation relation) {
            for (Symbol field : relation.outputs()) {
                ColumnIdent columnIdent = Symbols.pathFromSymbol(field);
                if (columnIdent.isSystemColumn()) continue;
                context.add(Symbols.pathFromSymbol(field), field);
            }
        }
    }
}

