/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations.select;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.sql.tree.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SelectAnalysis {
    private final Map<RelationName, AnalyzedRelation> sources;
    private final ExpressionAnalyzer expressionAnalyzer;
    private final ExpressionAnalysisContext expressionAnalysisContext;
    private final List<Symbol> outputSymbols;
    private final Multimap<String, Symbol> outputMultiMap;

    public SelectAnalysis(int expectedItems, Map<RelationName, AnalyzedRelation> sources, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext) {
        this.sources = sources;
        this.expressionAnalyzer = expressionAnalyzer;
        this.expressionAnalysisContext = expressionAnalysisContext;
        this.outputMultiMap = HashMultimap.create((int)expectedItems, (int)1);
        this.outputSymbols = new ArrayList<Symbol>(expectedItems);
    }

    public List<Symbol> outputSymbols() {
        return this.outputSymbols;
    }

    Symbol toSymbol(Expression expression) {
        return this.expressionAnalyzer.convert(expression, this.expressionAnalysisContext);
    }

    public Map<RelationName, AnalyzedRelation> sources() {
        return this.sources;
    }

    public Multimap<String, Symbol> outputMultiMap() {
        return this.outputMultiMap;
    }

    public void add(ColumnIdent path, Symbol symbol) {
        this.outputSymbols.add(symbol);
        this.outputMultiMap.put((Object)path.sqlFqn(), (Object)symbol);
    }
}

