/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.elasticsearch.common.UUIDs;

public class UnionSelect
implements AnalyzedRelation {
    private final AnalyzedRelation left;
    private final AnalyzedRelation right;
    private final List<ScopedSymbol> outputs;
    private final RelationName name;

    public UnionSelect(AnalyzedRelation left, AnalyzedRelation right) {
        assert (left.outputs().size() == right.outputs().size()) : "Both the left side and the right side of UNION must have the same number of outputs";
        this.left = left;
        this.right = right;
        this.name = new RelationName(null, UUIDs.randomBase64UUID());
        List<Symbol> fieldsFromLeft = left.outputs();
        ArrayList<ScopedSymbol> outputs = new ArrayList<ScopedSymbol>(fieldsFromLeft.size());
        for (Symbol field : fieldsFromLeft) {
            outputs.add(new ScopedSymbol(this.name, Symbols.pathFromSymbol(field), field.valueType()));
        }
        this.outputs = List.copyOf(outputs);
    }

    public AnalyzedRelation left() {
        return this.left;
    }

    public AnalyzedRelation right() {
        return this.right;
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitUnionSelect(this, context);
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation) throws UnsupportedOperationException, ColumnUnknownException {
        for (ScopedSymbol output : this.outputs) {
            if (!output.column().equals(column)) continue;
            return output;
        }
        return null;
    }

    @Override
    public RelationName relationName() {
        return this.name;
    }

    @Override
    @Nonnull
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public String toString() {
        return this.left + " UNION ALL " + this.right;
    }
}

