/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.analyze.relations.FieldResolver;
import io.crate.expression.scalar.SubscriptFunctions;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FunctionName;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.table.Operation;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.DataType;
import io.crate.types.RowType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TableFunctionRelation
implements AnalyzedRelation,
FieldResolver {
    private final TableFunctionImplementation<?> functionImplementation;
    private final Function function;
    private final List<Reference> outputs;
    private final RelationName relationName;

    public TableFunctionRelation(TableFunctionImplementation<?> functionImplementation, Function function) {
        this.functionImplementation = functionImplementation;
        this.function = function;
        RowType rowType = functionImplementation.returnType();
        this.outputs = new ArrayList<Reference>(rowType.numElements());
        int idx = 0;
        FunctionName functionName = function.fqnName();
        this.relationName = new RelationName(null, functionName.name());
        for (int i = 0; i < rowType.numElements(); ++i) {
            DataType<?> type = rowType.getFieldType(i);
            String fieldName = rowType.getFieldName(i);
            Reference ref = new Reference(new ReferenceIdent(this.relationName, fieldName), RowGranularity.DOC, type, idx, null);
            this.outputs.add(ref);
            ++idx;
        }
    }

    public Function function() {
        return this.function;
    }

    public TableFunctionImplementation<?> functionImplementation() {
        return this.functionImplementation;
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitTableFunctionRelation(this, context);
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation) throws UnsupportedOperationException {
        for (Symbol symbol : this.outputs) {
            ColumnIdent columnIdent = Symbols.pathFromSymbol(symbol);
            if (!column.equals(columnIdent)) continue;
            return symbol;
        }
        ColumnIdent rootColumn = column.getRoot();
        for (Symbol symbol : this.outputs) {
            ColumnIdent outputRoot = Symbols.pathFromSymbol(symbol).getRoot();
            if (symbol.valueType().id() != 12 || !rootColumn.equals(outputRoot)) continue;
            return SubscriptFunctions.makeObjectSubscript(symbol, column);
        }
        return null;
    }

    @Override
    public RelationName relationName() {
        return this.relationName;
    }

    @Override
    @Nonnull
    public List<Symbol> outputs() {
        return List.copyOf(this.outputs);
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Symbol symbol : this.outputs) {
            consumer.accept(symbol);
        }
        for (Symbol symbol : this.function.arguments()) {
            consumer.accept(symbol);
        }
    }

    @Override
    @Nullable
    public Symbol resolveField(ScopedSymbol field) {
        return this.getField(field.column(), Operation.READ);
    }

    public String toString() {
        return this.function.toString(Style.UNQUALIFIED);
    }
}

