/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.relations.ParentRelations;
import io.crate.analyze.relations.RelationAnalysisContext;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.table.Operation;
import java.util.ArrayList;
import java.util.List;

public class StatementAnalysisContext {
    private final ParamTypeHints paramTypeHints;
    private final Operation currentOperation;
    private final CoordinatorTxnCtx coordinatorTxnCtx;
    private final List<? extends Symbol> parentOutputColumns;
    private final List<RelationAnalysisContext> lastRelationContextQueue = new ArrayList<RelationAnalysisContext>();

    public StatementAnalysisContext(ParamTypeHints paramTypeHints, Operation currentOperation, CoordinatorTxnCtx coordinatorTxnCtx, List<? extends Symbol> parentOutputColumns) {
        this.paramTypeHints = paramTypeHints;
        this.currentOperation = currentOperation;
        this.coordinatorTxnCtx = coordinatorTxnCtx;
        this.parentOutputColumns = parentOutputColumns;
    }

    public StatementAnalysisContext(ParamTypeHints paramTypeHints, Operation currentOperation, CoordinatorTxnCtx coordinatorTxnCtx) {
        this(paramTypeHints, currentOperation, coordinatorTxnCtx, List.of());
    }

    public CoordinatorTxnCtx transactionContext() {
        return this.coordinatorTxnCtx;
    }

    Operation currentOperation() {
        return this.currentOperation;
    }

    public RelationAnalysisContext startRelation() {
        return this.startRelation(false);
    }

    RelationAnalysisContext startRelation(boolean aliasedRelation) {
        ParentRelations parentRelations;
        if (this.lastRelationContextQueue.isEmpty()) {
            parentRelations = ParentRelations.NO_PARENTS;
        } else {
            RelationAnalysisContext parentCtx = this.lastRelationContextQueue.get(this.lastRelationContextQueue.size() - 1);
            parentRelations = parentCtx.parentSources().newLevel(parentCtx.sources());
        }
        RelationAnalysisContext currentRelationContext = new RelationAnalysisContext(aliasedRelation, parentRelations);
        this.lastRelationContextQueue.add(currentRelationContext);
        return currentRelationContext;
    }

    public void endRelation() {
        if (this.lastRelationContextQueue.size() > 0) {
            this.lastRelationContextQueue.remove(this.lastRelationContextQueue.size() - 1);
        }
    }

    RelationAnalysisContext currentRelationContext() {
        assert (this.lastRelationContextQueue.size() > 0) : "relation context must be created using startRelation() first";
        return this.lastRelationContextQueue.get(this.lastRelationContextQueue.size() - 1);
    }

    public SessionContext sessionContext() {
        return this.coordinatorTxnCtx.sessionContext();
    }

    public ParamTypeHints paramTyeHints() {
        return this.paramTypeHints;
    }

    List<? extends Symbol> parentOutputColumns() {
        return this.parentOutputColumns;
    }
}

