/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import io.crate.analyze.OrderBy;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.QueriedSelectRelation;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.SubqueryAnalyzer;
import io.crate.analyze.relations.AliasedAnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedView;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.FieldResolver;
import io.crate.analyze.relations.FullQualifiedNameFieldProvider;
import io.crate.analyze.relations.JoinPair;
import io.crate.analyze.relations.OrderyByAnalyzer;
import io.crate.analyze.relations.RelationAnalysisContext;
import io.crate.analyze.relations.StatementAnalysisContext;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.analyze.relations.TableRelation;
import io.crate.analyze.relations.UnionSelect;
import io.crate.analyze.relations.select.SelectAnalysis;
import io.crate.analyze.relations.select.SelectAnalyzer;
import io.crate.analyze.validator.GroupBySymbolValidator;
import io.crate.analyze.validator.HavingSymbolValidator;
import io.crate.analyze.validator.SemanticSortValidator;
import io.crate.analyze.where.WhereClauseValidator;
import io.crate.common.collections.Lists2;
import io.crate.common.collections.Tuple;
import io.crate.exceptions.AmbiguousColumnAliasException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.RelationValidationException;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.scalar.arithmetic.ArrayFunction;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.GroupAndAggregateSemantics;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.tablefunctions.TableFunctionFactory;
import io.crate.expression.tablefunctions.ValuesFunction;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.SearchPath;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.metadata.view.ViewMetadata;
import io.crate.planner.consumer.OrderByWithAggregationValidator;
import io.crate.planner.node.dql.join.JoinType;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.AliasedRelation;
import io.crate.sql.tree.DefaultTraversalVisitor;
import io.crate.sql.tree.Except;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.FunctionCall;
import io.crate.sql.tree.Intersect;
import io.crate.sql.tree.Join;
import io.crate.sql.tree.JoinCriteria;
import io.crate.sql.tree.JoinOn;
import io.crate.sql.tree.JoinUsing;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.QuerySpecification;
import io.crate.sql.tree.Relation;
import io.crate.sql.tree.SortItem;
import io.crate.sql.tree.Table;
import io.crate.sql.tree.TableFunction;
import io.crate.sql.tree.TableSubquery;
import io.crate.sql.tree.Union;
import io.crate.sql.tree.Values;
import io.crate.sql.tree.ValuesList;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.RowType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class RelationAnalyzer
extends DefaultTraversalVisitor<AnalyzedRelation, StatementAnalysisContext> {
    private final NodeContext nodeCtx;
    private final Schemas schemas;
    private static final List<Relation> EMPTY_ROW_TABLE_RELATION = ImmutableList.of((Object)new TableFunction(new FunctionCall(QualifiedName.of("empty_row", new String[0]), Collections.emptyList())));

    @Inject
    public RelationAnalyzer(NodeContext nodeCtx, Schemas schemas) {
        this.nodeCtx = nodeCtx;
        this.schemas = schemas;
    }

    public AnalyzedRelation analyze(Node node, StatementAnalysisContext statementContext) {
        return node.accept(this, statementContext);
    }

    public AnalyzedRelation analyze(Query query, CoordinatorTxnCtx coordinatorTxnCtx, ParamTypeHints paramTypeHints) {
        return this.analyze(query, new StatementAnalysisContext(paramTypeHints, Operation.READ, coordinatorTxnCtx));
    }

    @Override
    protected AnalyzedRelation visitQuery(Query node, StatementAnalysisContext statementContext) {
        AnalyzedRelation childRelation = node.getQueryBody().accept(this, statementContext);
        if (node.getOrderBy().isEmpty() && node.getLimit().isEmpty() && node.getOffset().isEmpty()) {
            return childRelation;
        }
        statementContext.startRelation();
        RelationAnalysisContext relationAnalysisContext = statementContext.currentRelationContext();
        relationAnalysisContext.addSourceRelation(childRelation);
        statementContext.endRelation();
        List<Symbol> childRelationFields = childRelation.outputs();
        CoordinatorTxnCtx coordinatorTxnCtx = statementContext.transactionContext();
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(coordinatorTxnCtx, this.nodeCtx, statementContext.paramTyeHints(), new FullQualifiedNameFieldProvider(relationAnalysisContext.sources(), relationAnalysisContext.parentSources(), coordinatorTxnCtx.sessionContext().searchPath().currentSchema()), new SubqueryAnalyzer(this, statementContext));
        ExpressionAnalysisContext expressionAnalysisContext = relationAnalysisContext.expressionAnalysisContext();
        SelectAnalysis selectAnalysis = new SelectAnalysis(childRelationFields.size(), relationAnalysisContext.sources(), expressionAnalyzer, expressionAnalysisContext);
        for (Symbol field : childRelationFields) {
            selectAnalysis.add(Symbols.pathFromSymbol(field), field);
        }
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(this.nodeCtx, f -> expressionAnalysisContext.isEagerNormalizationAllowed() && f.isDeterministic());
        return new QueriedSelectRelation(false, List.of(childRelation), List.of(), selectAnalysis.outputSymbols(), Literal.BOOLEAN_TRUE, List.of(), null, RelationAnalyzer.analyzeOrderBy(selectAnalysis, node.getOrderBy(), expressionAnalyzer, expressionAnalysisContext, false, false), RelationAnalyzer.longSymbolOrNull(node.getLimit(), expressionAnalyzer, expressionAnalysisContext, normalizer, coordinatorTxnCtx), RelationAnalyzer.longSymbolOrNull(node.getOffset(), expressionAnalyzer, expressionAnalysisContext, normalizer, coordinatorTxnCtx));
    }

    @Override
    protected AnalyzedRelation visitUnion(Union node, StatementAnalysisContext context) {
        if (node.isDistinct()) {
            throw new UnsupportedFeatureException("UNION [DISTINCT] is not supported");
        }
        AnalyzedRelation left = node.getLeft().accept(this, context);
        AnalyzedRelation right = node.getRight().accept(this, context);
        RelationAnalyzer.ensureUnionOutputsHaveTheSameSize(left, right);
        RelationAnalyzer.ensureUnionOutputsHaveCompatibleTypes(left, right);
        return new UnionSelect(left, right);
    }

    private static void ensureUnionOutputsHaveTheSameSize(AnalyzedRelation left, AnalyzedRelation right) {
        if (left.outputs().size() != right.outputs().size()) {
            throw new UnsupportedOperationException("Number of output columns must be the same for all parts of a UNION");
        }
    }

    private static void ensureUnionOutputsHaveCompatibleTypes(AnalyzedRelation left, AnalyzedRelation right) {
        List<Symbol> leftOutputs = left.outputs();
        List<Symbol> rightOutputs = right.outputs();
        for (int i = 0; i < leftOutputs.size(); ++i) {
            DataType<?> rightType;
            DataType<?> leftType = leftOutputs.get(i).valueType();
            if (DataTypes.isSameType(leftType, rightType = rightOutputs.get(i).valueType())) continue;
            throw new UnsupportedOperationException("Corresponding output columns at position: " + (i + 1) + " must be compatible for all parts of a UNION");
        }
    }

    @Override
    protected AnalyzedRelation visitIntersect(Intersect node, StatementAnalysisContext context) {
        throw new UnsupportedFeatureException("INTERSECT is not supported");
    }

    @Override
    protected AnalyzedRelation visitExcept(Except node, StatementAnalysisContext context) {
        throw new UnsupportedFeatureException("EXCEPT is not supported");
    }

    @Override
    protected AnalyzedRelation visitJoin(Join node, StatementAnalysisContext statementContext) {
        AnalyzedRelation leftRel = node.getLeft().accept(this, statementContext);
        AnalyzedRelation rightRel = node.getRight().accept(this, statementContext);
        RelationAnalysisContext relationContext = statementContext.currentRelationContext();
        Optional<JoinCriteria> optCriteria = node.getCriteria();
        Symbol joinCondition = null;
        if (optCriteria.isPresent()) {
            JoinCriteria joinCriteria = optCriteria.get();
            if (joinCriteria instanceof JoinOn || joinCriteria instanceof JoinUsing) {
                CoordinatorTxnCtx coordinatorTxnCtx = statementContext.transactionContext();
                ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(coordinatorTxnCtx, this.nodeCtx, statementContext.paramTyeHints(), new FullQualifiedNameFieldProvider(relationContext.sources(), relationContext.parentSources(), coordinatorTxnCtx.sessionContext().searchPath().currentSchema()), new SubqueryAnalyzer(this, statementContext));
                Expression expr = joinCriteria instanceof JoinOn ? ((JoinOn)joinCriteria).getExpression() : JoinUsing.toExpression(leftRel.relationName().toQualifiedName(), rightRel.relationName().toQualifiedName(), ((JoinUsing)joinCriteria).getColumns());
                try {
                    joinCondition = expressionAnalyzer.convert(expr, relationContext.expressionAnalysisContext());
                }
                catch (RelationUnknown e) {
                    throw new RelationValidationException(e.getTableIdents(), String.format(Locale.ENGLISH, "missing FROM-clause entry for relation '%s'", e.getTableIdents()));
                }
            } else {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "join criteria %s not supported", joinCriteria.getClass().getSimpleName()));
            }
        }
        relationContext.addJoinType(JoinType.values()[node.getType().ordinal()], joinCondition);
        return null;
    }

    @Override
    protected AnalyzedRelation visitQuerySpecification(QuerySpecification node, StatementAnalysisContext statementContext) {
        List<Relation> from = node.getFrom().isEmpty() ? EMPTY_ROW_TABLE_RELATION : node.getFrom();
        RelationAnalysisContext currentRelationContext = statementContext.startRelation();
        for (Relation relation : from) {
            RelationAnalysisContext innerContext = statementContext.startRelation();
            relation.accept(this, statementContext);
            statementContext.endRelation();
            for (Map.Entry<RelationName, AnalyzedRelation> entry : innerContext.sources().entrySet()) {
                currentRelationContext.addSourceRelation(entry.getValue());
            }
            for (JoinPair joinPair : innerContext.joinPairs()) {
                currentRelationContext.addJoinPair(joinPair);
            }
        }
        RelationAnalysisContext context = statementContext.currentRelationContext();
        CoordinatorTxnCtx coordinatorTxnCtx = statementContext.transactionContext();
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(coordinatorTxnCtx, this.nodeCtx, statementContext.paramTyeHints(), new FullQualifiedNameFieldProvider(context.sources(), context.parentSources(), coordinatorTxnCtx.sessionContext().searchPath().currentSchema()), new SubqueryAnalyzer(this, statementContext));
        ExpressionAnalysisContext expressionAnalysisContext = context.expressionAnalysisContext();
        expressionAnalysisContext.windows(node.getWindows());
        SelectAnalysis selectAnalysis = SelectAnalyzer.analyzeSelectItems(node.getSelect().getSelectItems(), context.sources(), expressionAnalyzer, expressionAnalysisContext);
        List<Symbol> groupBy = this.analyzeGroupBy(selectAnalysis, node.getGroupBy(), expressionAnalyzer, expressionAnalysisContext);
        if (!node.getGroupBy().isEmpty() || expressionAnalysisContext.hasAggregates()) {
            GroupAndAggregateSemantics.validate(selectAnalysis.outputSymbols(), groupBy);
        }
        boolean isDistinct = node.getSelect().isDistinct();
        Symbol where = expressionAnalyzer.generateQuerySymbol(node.getWhere(), expressionAnalysisContext);
        WhereClauseValidator.validate(where);
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(this.nodeCtx, f -> expressionAnalysisContext.isEagerNormalizationAllowed() && f.isDeterministic());
        QueriedSelectRelation relation = new QueriedSelectRelation(isDistinct, List.copyOf(context.sources().values()), context.joinPairs(), selectAnalysis.outputSymbols(), where, groupBy, this.analyzeHaving(node.getHaving(), groupBy, expressionAnalyzer, context.expressionAnalysisContext()), RelationAnalyzer.analyzeOrderBy(selectAnalysis, node.getOrderBy(), expressionAnalyzer, expressionAnalysisContext, expressionAnalysisContext.hasAggregates() || !groupBy.isEmpty(), isDistinct), RelationAnalyzer.longSymbolOrNull(node.getLimit(), expressionAnalyzer, expressionAnalysisContext, normalizer, coordinatorTxnCtx), RelationAnalyzer.longSymbolOrNull(node.getOffset(), expressionAnalyzer, expressionAnalysisContext, normalizer, coordinatorTxnCtx));
        statementContext.endRelation();
        return relation;
    }

    @Nullable
    private static Symbol longSymbolOrNull(Optional<Expression> optExpression, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext, EvaluatingNormalizer normalizer, CoordinatorTxnCtx coordinatorTxnCtx) {
        if (optExpression.isPresent()) {
            Symbol symbol = expressionAnalyzer.convert(optExpression.get(), expressionAnalysisContext);
            return normalizer.normalize(symbol.cast(DataTypes.LONG, new CastMode[0]), coordinatorTxnCtx);
        }
        return null;
    }

    @Nullable
    private static OrderBy analyzeOrderBy(SelectAnalysis selectAnalysis, List<SortItem> orderBy, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext, boolean hasAggregatesOrGrouping, boolean isDistinct) {
        return OrderyByAnalyzer.analyzeSortItems(orderBy, sortKey -> {
            Symbol symbol = RelationAnalyzer.symbolFromSelectOutputReferenceOrExpression(sortKey, selectAnalysis, "ORDER BY", expressionAnalyzer, expressionAnalysisContext);
            SemanticSortValidator.validate(symbol);
            if (hasAggregatesOrGrouping) {
                OrderByWithAggregationValidator.validate(symbol, selectAnalysis.outputSymbols(), isDistinct);
            }
            return symbol;
        });
    }

    private List<Symbol> analyzeGroupBy(SelectAnalysis selectAnalysis, List<Expression> groupBy, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext) {
        ArrayList<Symbol> groupBySymbols = new ArrayList<Symbol>(groupBy.size());
        for (Expression expression : groupBy) {
            Symbol symbol = RelationAnalyzer.symbolFromExpressionFallbackOnSelectOutput(expression, selectAnalysis, "GROUP BY", expressionAnalyzer, expressionAnalysisContext);
            GroupBySymbolValidator.validate(symbol);
            groupBySymbols.add(symbol);
        }
        return groupBySymbols;
    }

    @Nullable
    private Symbol analyzeHaving(Optional<Expression> having, @Nullable List<Symbol> groupBy, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext) {
        if (having.isPresent()) {
            if (!expressionAnalysisContext.hasAggregates() && (groupBy == null || groupBy.isEmpty())) {
                throw new IllegalArgumentException("HAVING clause can only be used in GROUP BY or global aggregate queries");
            }
            Symbol symbol = expressionAnalyzer.convert(having.get(), expressionAnalysisContext);
            HavingSymbolValidator.validate(symbol, groupBy);
            return symbol;
        }
        return null;
    }

    private static Symbol symbolFromSelectOutputReferenceOrExpression(Expression expression, SelectAnalysis selectAnalysis, String clause, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext) {
        Symbol symbol;
        if (expression instanceof QualifiedNameReference && (symbol = RelationAnalyzer.tryGetFromSelectList((QualifiedNameReference)expression, selectAnalysis)) != null) {
            return symbol;
        }
        symbol = expressionAnalyzer.convert(expression, expressionAnalysisContext);
        if (symbol instanceof Literal) {
            symbol = RelationAnalyzer.getByPosition(selectAnalysis.outputSymbols(), (Literal)symbol, clause);
        }
        return symbol;
    }

    @Nullable
    private static Symbol tryGetFromSelectList(QualifiedNameReference expression, SelectAnalysis selectAnalysis) {
        List<String> parts = expression.getName().getParts();
        if (parts.size() == 1) {
            return RelationAnalyzer.getOneOrAmbiguous(selectAnalysis.outputMultiMap(), (String)Iterables.getOnlyElement(parts));
        }
        return null;
    }

    private static Symbol symbolFromExpressionFallbackOnSelectOutput(Expression expression, SelectAnalysis selectAnalysis, String clause, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext) {
        try {
            Symbol symbol = expressionAnalyzer.convert(expression, expressionAnalysisContext);
            if (symbol instanceof Literal) {
                return RelationAnalyzer.getByPosition(selectAnalysis.outputSymbols(), (Literal)symbol, clause);
            }
            return symbol;
        }
        catch (ColumnUnknownException e) {
            Symbol symbol;
            if (expression instanceof QualifiedNameReference && (symbol = RelationAnalyzer.tryGetFromSelectList((QualifiedNameReference)expression, selectAnalysis)) != null) {
                return symbol;
            }
            throw e;
        }
    }

    private static Symbol getByPosition(List<Symbol> outputSymbols, Literal<?> ordinal, String clause) {
        Integer ord;
        try {
            ord = DataTypes.INTEGER.sanitizeValue(ordinal.value());
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use %s in %s clause", ordinal, clause));
        }
        if (ord == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use %s in %s clause", ordinal, clause));
        }
        return RelationAnalyzer.ordinalOutputReference(outputSymbols, ord, clause);
    }

    private static Symbol ordinalOutputReference(List<Symbol> outputSymbols, int ordinal, String clauseName) {
        int idx = ordinal - 1;
        if (idx < 0) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "%s position %s is not in select list", clauseName, idx + 1));
        }
        try {
            return outputSymbols.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "%s position %s is not in select list", clauseName, idx + 1));
        }
    }

    @Nullable
    private static Symbol getOneOrAmbiguous(Multimap<String, Symbol> selectList, String key) throws AmbiguousColumnAliasException {
        Collection symbols = selectList.get((Object)key);
        if (symbols.size() > 1) {
            throw new AmbiguousColumnAliasException(key, symbols);
        }
        if (symbols.isEmpty()) {
            return null;
        }
        return (Symbol)symbols.iterator().next();
    }

    @Override
    protected AnalyzedRelation visitAliasedRelation(AliasedRelation node, StatementAnalysisContext context) {
        context.startRelation(true);
        AnalyzedRelation childRelation = node.getRelation().accept(this, context);
        AliasedAnalyzedRelation aliasedRelation = new AliasedAnalyzedRelation(childRelation, new RelationName(null, node.getAlias()), node.getColumnNames());
        context.endRelation();
        context.currentRelationContext().addSourceRelation(aliasedRelation);
        return aliasedRelation;
    }

    @Override
    protected AnalyzedRelation visitTable(Table<?> node, StatementAnalysisContext context) {
        FieldResolver relation;
        QualifiedName tableQualifiedName = node.getName();
        SearchPath searchPath = context.sessionContext().searchPath();
        try {
            TableInfo tableInfo = this.schemas.resolveTableInfo(tableQualifiedName, context.currentOperation(), context.sessionContext().sessionUser(), searchPath);
            relation = tableInfo instanceof DocTableInfo ? new DocTableRelation((DocTableInfo)tableInfo) : new TableRelation(tableInfo);
        }
        catch (RelationUnknown e) {
            Tuple<ViewMetadata, RelationName> viewMetadata;
            try {
                viewMetadata = this.schemas.resolveView(tableQualifiedName, searchPath);
            }
            catch (RelationUnknown e1) {
                throw e;
            }
            ViewMetadata view = viewMetadata.v1();
            AnalyzedRelation resolvedView = SqlParser.createStatement(view.stmt()).accept(this, context);
            relation = new AnalyzedView(viewMetadata.v2(), view.owner(), resolvedView);
        }
        context.currentRelationContext().addSourceRelation((AnalyzedRelation)((Object)relation));
        return relation;
    }

    @Override
    public AnalyzedRelation visitTableFunction(TableFunction node, StatementAnalysisContext statementContext) {
        RelationAnalysisContext context = statementContext.currentRelationContext();
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(statementContext.transactionContext(), this.nodeCtx, statementContext.paramTyeHints(), FieldProvider.UNSUPPORTED, null);
        ExpressionAnalysisContext expressionContext = context.expressionAnalysisContext();
        boolean allowEagerNormalizeOriginalValue = expressionContext.isEagerNormalizationAllowed();
        expressionContext.allowEagerNormalize(false);
        Symbol symbol = expressionAnalyzer.convert(node.functionCall(), expressionContext);
        expressionContext.allowEagerNormalize(allowEagerNormalizeOriginalValue);
        if (!(symbol instanceof io.crate.expression.symbol.Function)) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Symbol '%s' is not supported in FROM clause", node.name()));
        }
        io.crate.expression.symbol.Function function = (io.crate.expression.symbol.Function)symbol;
        FunctionImplementation functionImplementation = this.nodeCtx.functions().getQualified(function, statementContext.sessionContext().searchPath());
        assert (functionImplementation != null) : "Function implementation not found using full qualified lookup";
        TableFunctionImplementation<?> tableFunction = TableFunctionFactory.from(functionImplementation);
        TableFunctionRelation tableRelation = new TableFunctionRelation(tableFunction, function);
        context.addSourceRelation(tableRelation);
        return tableRelation;
    }

    @Override
    protected AnalyzedRelation visitTableSubquery(TableSubquery node, StatementAnalysisContext context) {
        if (!context.currentRelationContext().isAliasedRelation()) {
            throw new UnsupportedOperationException("subquery in FROM clause must have an alias");
        }
        return (AnalyzedRelation)super.visitTableSubquery(node, context);
    }

    @Override
    public AnalyzedRelation visitValues(Values values, StatementAnalysisContext context) {
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(context.transactionContext(), this.nodeCtx, context.paramTyeHints(), FieldProvider.UNSUPPORTED, new SubqueryAnalyzer(this, context));
        ExpressionAnalysisContext expressionAnalysisContext = new ExpressionAnalysisContext();
        expressionAnalysisContext.allowEagerNormalize(false);
        Function<Expression, Symbol> expressionToSymbol = e -> expressionAnalyzer.convert((Expression)e, expressionAnalysisContext);
        List<ValuesList> rows = values.rows();
        assert (rows.size() > 0) : "Parser grammar enforces at least 1 row";
        ValuesList firstRow = rows.get(0);
        int numColumns = firstRow.values().size();
        ArrayList columns = new ArrayList();
        ArrayList<DataType> targetTypes = new ArrayList<DataType>(numColumns);
        List<? extends Symbol> parentOutputColumns = context.parentOutputColumns();
        for (int c = 0; c < numColumns; ++c) {
            ArrayList<Symbol> columnValues = new ArrayList<Symbol>();
            DataType targetType = parentOutputColumns.size() > c ? parentOutputColumns.get(c).valueType() : DataTypes.UNDEFINED;
            for (int r = 0; r < rows.size(); ++r) {
                List<Expression> row = rows.get(r).values();
                if (row.size() != numColumns) {
                    throw new IllegalArgumentException("VALUES lists must all be the same length. Found row with " + numColumns + " items and another with " + columns.size() + " items");
                }
                Symbol cell = expressionToSymbol.apply(row.get(c));
                columnValues.add(cell);
                DataType<?> cellType = cell.valueType();
                if (r > 0 && !cellType.isConvertableTo(targetType, false) && ((DataType)targetType).id() != DataTypes.UNDEFINED.id()) {
                    throw new IllegalArgumentException("The types of the columns within VALUES lists must match. Found `" + targetType + "` and `" + cellType + "` at position: " + c);
                }
                if (!cellType.precedes(targetType)) continue;
                targetType = cellType;
            }
            targetTypes.add(targetType);
            columns.add(columnValues);
        }
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(this.nodeCtx, f -> f.isDeterministic());
        ArrayList<Symbol> arrays = new ArrayList<Symbol>(columns.size());
        for (int c = 0; c < numColumns; ++c) {
            DataType targetType = (DataType)targetTypes.get(c);
            ArrayType arrayType = new ArrayType(targetType);
            List<Symbol> columnValues = Lists2.map((Collection)columns.get(c), s -> normalizer.normalize(s.cast(targetType, new CastMode[0]), context.transactionContext()));
            arrays.add(new io.crate.expression.symbol.Function(ArrayFunction.SIGNATURE, columnValues, arrayType));
        }
        FunctionImplementation implementation = this.nodeCtx.functions().getQualified(ValuesFunction.SIGNATURE, Symbols.typeView(arrays), RowType.EMPTY);
        io.crate.expression.symbol.Function function = new io.crate.expression.symbol.Function(implementation.signature(), arrays, RowType.EMPTY);
        TableFunctionImplementation<?> tableFunc = TableFunctionFactory.from(implementation);
        TableFunctionRelation relation = new TableFunctionRelation(tableFunc, function);
        context.startRelation();
        context.currentRelationContext().addSourceRelation(relation);
        context.endRelation();
        return relation;
    }
}

