/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.JoinPair;
import io.crate.analyze.relations.ParentRelations;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.node.dql.join.JoinType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class RelationAnalysisContext {
    private final ExpressionAnalysisContext expressionAnalysisContext;
    private final boolean aliasedRelation;
    private final ParentRelations parents;
    private final Map<RelationName, AnalyzedRelation> sources = new LinkedHashMap<RelationName, AnalyzedRelation>();
    @Nullable
    private List<JoinPair> joinPairs;

    RelationAnalysisContext(boolean aliasedRelation, ParentRelations parents) {
        this.aliasedRelation = aliasedRelation;
        this.parents = parents;
        this.expressionAnalysisContext = new ExpressionAnalysisContext();
    }

    boolean isAliasedRelation() {
        return this.aliasedRelation;
    }

    public Map<RelationName, AnalyzedRelation> sources() {
        return this.sources;
    }

    void addJoinPair(JoinPair joinType) {
        if (this.joinPairs == null) {
            this.joinPairs = new ArrayList<JoinPair>();
        }
        this.joinPairs.add(joinType);
    }

    void addJoinType(JoinType joinType, @Nullable Symbol joinCondition) {
        int size = this.sources.size();
        assert (size >= 2) : "sources must be added first, cannot add join type for only 1 source";
        Iterator<RelationName> it = this.sources.keySet().iterator();
        RelationName left = null;
        RelationName right = null;
        int idx = 0;
        while (it.hasNext()) {
            RelationName sourceName = it.next();
            if (idx == size - 2) {
                left = sourceName;
            } else if (idx == size - 1) {
                right = sourceName;
            }
            ++idx;
        }
        this.addJoinPair(JoinPair.of(left, right, joinType, joinCondition));
    }

    List<JoinPair> joinPairs() {
        if (this.joinPairs == null) {
            return List.of();
        }
        return this.joinPairs;
    }

    void addSourceRelation(AnalyzedRelation relation) {
        RelationName relationName = relation.relationName();
        if (this.sources.put(relationName, relation) != null) {
            String errorMessage = String.format(Locale.ENGLISH, "\"%s\" specified more than once in the FROM clause", relationName);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public ExpressionAnalysisContext expressionAnalysisContext() {
        return this.expressionAnalysisContext;
    }

    public ParentRelations parentSources() {
        return this.parents;
    }
}

