/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.functions.Signature;
import io.crate.planner.consumer.RelationNameCollector;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class QuerySplitter {
    private static final SplitVisitor SPLIT_VISITOR = new SplitVisitor();

    public static Map<Set<RelationName>, Symbol> split(Symbol query) {
        Context context = new Context(query);
        query.accept(SPLIT_VISITOR, context);
        return context.parts;
    }

    private static class Context {
        final Set<RelationName> allNames;
        final LinkedHashMap<Set<RelationName>, Symbol> parts;

        public Context(Symbol query) {
            this.allNames = RelationNameCollector.collect(query);
            this.parts = new LinkedHashMap();
        }
    }

    private static class SplitVisitor
    extends SymbolVisitor<Context, Void> {
        private SplitVisitor() {
        }

        @Override
        public Void visitLiteral(Literal literal, Context ctx) {
            Symbol prevQuery = ctx.parts.put(ctx.allNames, literal);
            if (prevQuery != null) {
                ctx.parts.put(ctx.allNames, AndOperator.of(prevQuery, literal));
            }
            return null;
        }

        @Override
        public Void visitFunction(Function function, Context ctx) {
            Signature signature = function.signature();
            assert (signature != null) : "Expecting functions signature not to be null";
            if (!signature.equals(AndOperator.SIGNATURE)) {
                Set<RelationName> qualifiedNames = RelationNameCollector.collect(function);
                Symbol prevQuery = ctx.parts.put(qualifiedNames, function);
                if (prevQuery != null) {
                    ctx.parts.put(qualifiedNames, AndOperator.of(prevQuery, function));
                }
                return null;
            }
            for (Symbol arg : function.arguments()) {
                arg.accept(this, ctx);
            }
            return null;
        }

        @Override
        public Void visitField(ScopedSymbol field, Context ctx) {
            ctx.parts.put(Collections.singleton(field.relation()), field);
            return null;
        }

        @Override
        public Void visitReference(Reference ref, Context ctx) {
            ctx.parts.put(Set.of(ref.ident().tableIdent()), ref);
            return null;
        }

        @Override
        public Void visitMatchPredicate(MatchPredicate matchPredicate, Context ctx) {
            LinkedHashSet<RelationName> relationNames = new LinkedHashSet<RelationName>();
            for (Symbol field : matchPredicate.identBoostMap().keySet()) {
                if (field instanceof ScopedSymbol) {
                    relationNames.add(((ScopedSymbol)field).relation());
                    continue;
                }
                if (!(field instanceof Reference)) continue;
                relationNames.add(((Reference)field).ident().tableIdent());
            }
            ctx.parts.put(relationNames, matchPredicate);
            return null;
        }
    }
}

