/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.metadata.RelationName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ParentRelations {
    public static final ParentRelations NO_PARENTS = new ParentRelations();
    private final List<Map<RelationName, AnalyzedRelation>> sourcesTree;

    private ParentRelations() {
        this.sourcesTree = Collections.emptyList();
    }

    private ParentRelations(ArrayList<Map<RelationName, AnalyzedRelation>> sourcesTree) {
        this.sourcesTree = sourcesTree;
    }

    public ParentRelations newLevel(Map<RelationName, AnalyzedRelation> sources) {
        ArrayList<Map<RelationName, AnalyzedRelation>> newSourcesTree = new ArrayList<Map<RelationName, AnalyzedRelation>>(this.sourcesTree);
        newSourcesTree.add(sources);
        return new ParentRelations(newSourcesTree);
    }

    public boolean containsRelation(RelationName qualifiedName) {
        for (int i = this.sourcesTree.size() - 1; i >= 0; --i) {
            if (!this.sourcesTree.get(i).containsKey(qualifiedName)) continue;
            return true;
        }
        return false;
    }
}

