/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.OrderBy;
import io.crate.expression.symbol.Symbol;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.SortItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public class OrderyByAnalyzer {
    @Nullable
    public static OrderBy analyzeSortItems(List<SortItem> sortItems, Function<Expression, Symbol> expressionToSymbolFunction) {
        int size = sortItems.size();
        if (size == 0) {
            return null;
        }
        ArrayList<Symbol> symbols = new ArrayList<Symbol>(size);
        boolean[] reverseFlags = new boolean[size];
        boolean[] nullsFirst = new boolean[size];
        for (int i = 0; i < size; ++i) {
            SortItem sortItem = sortItems.get(i);
            Expression sortKey = sortItem.getSortKey();
            Symbol symbol = expressionToSymbolFunction.apply(sortKey);
            symbols.add(symbol);
            switch (sortItem.getNullOrdering()) {
                case FIRST: {
                    nullsFirst[i] = true;
                    break;
                }
                case LAST: {
                    nullsFirst[i] = false;
                    break;
                }
                case UNDEFINED: {
                    nullsFirst[i] = sortItem.getOrdering() == SortItem.Ordering.DESCENDING;
                    break;
                }
            }
            reverseFlags[i] = sortItem.getOrdering() == SortItem.Ordering.DESCENDING;
        }
        return new OrderBy(symbols, reverseFlags, nullsFirst);
    }
}

