/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.FieldProvider;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.QualifiedName;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class NameFieldProvider
implements FieldProvider<Symbol> {
    private AnalyzedRelation relation;

    public NameFieldProvider(AnalyzedRelation relation) {
        this.relation = relation;
    }

    @Override
    public Symbol resolveField(QualifiedName qualifiedName, @Nullable List<String> path, Operation operation) {
        List<String> parts = qualifiedName.getParts();
        ColumnIdent columnIdent = new ColumnIdent(parts.get(parts.size() - 1), path);
        if (parts.size() != 1) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column reference \"%s\" has too many parts. A column must not have a schema or a table here.", qualifiedName));
        }
        Symbol field = this.relation.getField(columnIdent, operation);
        if (field == null) {
            throw new ColumnUnknownException(columnIdent.sqlFqn(), this.relation.relationName());
        }
        return field;
    }
}

