/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.node.dql.join.JoinType;
import java.util.Objects;
import javax.annotation.Nullable;

public class JoinPair {
    private final JoinType joinType;
    private final RelationName left;
    private final RelationName right;
    @Nullable
    private final Symbol condition;

    public static JoinPair of(RelationName left, RelationName right, JoinType joinType, Symbol condition) {
        assert (condition != null || joinType == JoinType.CROSS) : "condition must be present unless it's a cross-join";
        return new JoinPair(left, right, joinType, condition);
    }

    private JoinPair(RelationName left, RelationName right, JoinType joinType, @Nullable Symbol condition) {
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.condition = condition;
    }

    public RelationName left() {
        return this.left;
    }

    public RelationName right() {
        return this.right;
    }

    public JoinType joinType() {
        return this.joinType;
    }

    @Nullable
    public Symbol condition() {
        return this.condition;
    }

    public String toString() {
        return "Join{" + this.joinType + " " + this.left + " \u21d4 " + this.right + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinPair joinPair = (JoinPair)o;
        return this.joinType == joinPair.joinType && Objects.equals(this.left, joinPair.left) && Objects.equals(this.right, joinPair.right) && Objects.equals(this.condition, joinPair.condition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.joinType, this.left, this.right, this.condition});
    }
}

