/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.ParentRelations;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.RelationUnknown;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.QualifiedName;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class FullQualifiedNameFieldProvider
implements FieldProvider<Symbol> {
    private final Map<RelationName, AnalyzedRelation> sources;
    private final ParentRelations parents;
    private final String defaultSchema;

    public FullQualifiedNameFieldProvider(Map<RelationName, AnalyzedRelation> sources, ParentRelations parents, String defaultSchema) {
        this.sources = Objects.requireNonNull(sources, "Please provide a source map.");
        this.parents = Objects.requireNonNull(parents, "ParentRelations must not be null");
        this.defaultSchema = Objects.requireNonNull(defaultSchema, "Default schema must not be null");
    }

    @Override
    public Symbol resolveField(QualifiedName qualifiedName, @Nullable List<String> path, Operation operation) {
        List<String> parts = qualifiedName.getParts();
        String columnSchema = null;
        String columnTableName = null;
        ColumnIdent columnIdent = new ColumnIdent(parts.get(parts.size() - 1), path);
        switch (parts.size()) {
            case 1: {
                break;
            }
            case 2: {
                columnTableName = parts.get(0);
                break;
            }
            case 3: {
                columnSchema = parts.get(0);
                columnTableName = parts.get(1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Column reference \"%s\" has too many parts. A column reference can have at most 3 parts and must have one of the following formats:  \"<column>\", \"<table>.<column>\" or \"<schema>.<table>.<column>\"");
            }
        }
        boolean schemaMatched = false;
        boolean tableNameMatched = false;
        Symbol lastField = null;
        for (Map.Entry<RelationName, AnalyzedRelation> entry : this.sources.entrySet()) {
            RelationName relName = entry.getKey();
            String sourceSchema = relName.schema();
            String sourceTableOrAlias = relName.name();
            if (columnSchema != null && !columnSchema.equals(sourceSchema)) continue;
            schemaMatched = true;
            if (columnTableName != null && !sourceTableOrAlias.equals(columnTableName)) continue;
            tableNameMatched = true;
            AnalyzedRelation sourceRelation = entry.getValue();
            Symbol newField = sourceRelation.getField(columnIdent, operation);
            if (newField == null) continue;
            if (lastField != null) {
                throw new AmbiguousColumnException(columnIdent, newField);
            }
            lastField = newField;
        }
        if (lastField == null) {
            if (!schemaMatched || !tableNameMatched) {
                String schema = columnSchema == null ? this.defaultSchema : columnSchema;
                this.raiseUnsupportedFeatureIfInParentScope(columnSchema, columnTableName, schema);
                RelationName relationName = new RelationName(schema, columnTableName);
                throw new RelationUnknown(relationName);
            }
            RelationName relationName = this.sources.entrySet().iterator().next().getKey();
            throw new ColumnUnknownException(columnIdent.sqlFqn(), relationName);
        }
        return lastField;
    }

    private void raiseUnsupportedFeatureIfInParentScope(String columnSchema, String columnTableName, String schema) {
        RelationName name = new RelationName(schema, columnTableName);
        if (this.parents.containsRelation(name)) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot use relation \"%s.%s\" in this context. It is only accessible in the parent context.", schema, columnTableName));
        }
        if (columnSchema == null && this.parents.containsRelation(new RelationName(null, columnTableName))) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot use relation \"%s\" in this context. It is only accessible in the parent context.", columnTableName));
        }
    }
}

