/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.ValuesResolver;
import io.crate.analyze.relations.FieldProvider;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.QualifiedName;
import java.util.List;
import javax.annotation.Nullable;

public class ExcludedFieldProvider
implements FieldProvider<Symbol> {
    private ValuesResolver valuesResolver;
    private FieldProvider<?> fieldProvider;

    public ExcludedFieldProvider(FieldProvider<?> fieldProvider, ValuesResolver valuesResolver) {
        this.fieldProvider = fieldProvider;
        this.valuesResolver = valuesResolver;
    }

    @Override
    public Symbol resolveField(QualifiedName qualifiedName, @Nullable List<String> path, Operation operation) {
        List<String> parts = qualifiedName.getParts();
        if (parts.size() == 2 && parts.get(0).equals("excluded")) {
            String colName = parts.get(1);
            Object symbol = this.fieldProvider.resolveField(new QualifiedName(colName), path, operation);
            return this.valuesResolver.allocateAndResolve((Symbol)symbol);
        }
        return this.fieldProvider.resolveField(qualifiedName, path, operation);
    }
}

