/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.analyze.relations.FieldResolver;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AnalyzedView
implements AnalyzedRelation,
FieldResolver {
    private final RelationName name;
    private final String owner;
    private final AnalyzedRelation relation;
    private final List<Symbol> outputSymbols;

    public AnalyzedView(RelationName name, String owner, AnalyzedRelation relation) {
        this.name = name;
        this.owner = owner;
        this.relation = relation;
        List<Symbol> childOutputs = relation.outputs();
        ArrayList<ScopedSymbol> outputs = new ArrayList<ScopedSymbol>(childOutputs.size());
        for (int i = 0; i < childOutputs.size(); ++i) {
            Symbol output = childOutputs.get(i);
            ColumnIdent column = Symbols.pathFromSymbol(output);
            outputs.add(new ScopedSymbol(name, column, output.valueType()));
        }
        this.outputSymbols = List.copyOf(outputs);
    }

    public String owner() {
        return this.owner;
    }

    public AnalyzedRelation relation() {
        return this.relation;
    }

    public RelationName name() {
        return this.name;
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitView(this, context);
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        this.relation.visitSymbols(consumer);
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation) throws UnsupportedOperationException, ColumnUnknownException {
        Symbol field = this.relation.getField(column, operation);
        if (field == null) {
            return null;
        }
        ScopedSymbol scopedSymbol = new ScopedSymbol(this.name, column, field.valueType());
        int i = this.outputSymbols.indexOf(scopedSymbol);
        if (i >= 0) {
            return this.outputSymbols.get(i);
        }
        return scopedSymbol;
    }

    @Override
    public RelationName relationName() {
        return this.name;
    }

    @Override
    @Nonnull
    public List<Symbol> outputs() {
        return this.outputSymbols;
    }

    public String toString() {
        return "AnalyzedView{qualifiedName=" + this.name + ", relation=" + this.relation + "}";
    }

    @Override
    @Nullable
    public Symbol resolveField(ScopedSymbol field) {
        if (!field.relation().equals(this.name)) {
            throw new IllegalArgumentException(field + " does not belong to " + this.name);
        }
        return this.relation.getField(field.column(), Operation.READ);
    }
}

