/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.AnalyzedShowCreateTable;
import io.crate.analyze.ExplainAnalyzedStatement;
import io.crate.analyze.QueriedSelectRelation;
import io.crate.analyze.relations.AliasedAnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedView;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.analyze.relations.TableRelation;
import io.crate.analyze.relations.UnionSelect;
import java.util.Locale;

public abstract class AnalyzedRelationVisitor<C, R> {
    protected R visitAnalyzedRelation(AnalyzedRelation relation, C context) {
        throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "relation \"%s\" is not supported", relation));
    }

    public R visitUnionSelect(UnionSelect unionSelect, C context) {
        return this.visitAnalyzedRelation(unionSelect, context);
    }

    public R visitTableRelation(TableRelation tableRelation, C context) {
        return this.visitAnalyzedRelation(tableRelation, context);
    }

    public R visitDocTableRelation(DocTableRelation relation, C context) {
        return this.visitAnalyzedRelation(relation, context);
    }

    public R visitExplain(ExplainAnalyzedStatement explainAnalyzedStatement, C context) {
        return this.visitAnalyzedRelation(explainAnalyzedStatement, context);
    }

    public R visitTableFunctionRelation(TableFunctionRelation tableFunctionRelation, C context) {
        return this.visitAnalyzedRelation(tableFunctionRelation, context);
    }

    public R visitQueriedSelectRelation(QueriedSelectRelation relation, C context) {
        return this.visitAnalyzedRelation(relation, context);
    }

    public R visitView(AnalyzedView analyzedView, C context) {
        return analyzedView.relation().accept(this, context);
    }

    public R visitAliasedAnalyzedRelation(AliasedAnalyzedRelation relation, C context) {
        return relation.relation().accept(this, context);
    }

    public R visitShowCreateTable(AnalyzedShowCreateTable analyzedShowCreateTable, C context) {
        return this.visitAnalyzedRelation(analyzedShowCreateTable, context);
    }
}

