/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.analyze.relations.FieldResolver;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AliasedAnalyzedRelation
implements AnalyzedRelation,
FieldResolver {
    private final AnalyzedRelation relation;
    private final RelationName alias;
    private final Map<ColumnIdent, ColumnIdent> aliasToColumnMapping;
    private final ArrayList<Symbol> outputs;
    private final ArrayList<ScopedSymbol> scopedSymbols;

    public AliasedAnalyzedRelation(AnalyzedRelation relation, RelationName alias) {
        this(relation, alias, List.of());
    }

    AliasedAnalyzedRelation(AnalyzedRelation relation, RelationName alias, List<String> columnAliases) {
        this.relation = relation;
        this.alias = alias;
        this.aliasToColumnMapping = new HashMap<ColumnIdent, ColumnIdent>(columnAliases.size());
        this.outputs = new ArrayList(relation.outputs().size());
        this.scopedSymbols = new ArrayList(relation.outputs().size());
        for (int i = 0; i < relation.outputs().size(); ++i) {
            ColumnIdent childColumn;
            Symbol childOutput = relation.outputs().get(i);
            ColumnIdent columnAlias = childColumn = Symbols.pathFromSymbol(childOutput);
            if (i < columnAliases.size()) {
                columnAlias = new ColumnIdent(columnAliases.get(i));
            }
            this.aliasToColumnMapping.put(columnAlias, childColumn);
            ScopedSymbol scopedSymbol = new ScopedSymbol(alias, columnAlias, childOutput.valueType());
            this.outputs.add(scopedSymbol);
            this.scopedSymbols.add(scopedSymbol);
        }
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation) throws UnsupportedOperationException, ColumnUnknownException {
        Symbol field;
        if (operation != Operation.READ) {
            throw new UnsupportedOperationException(operation + " is not supported on " + this.alias);
        }
        ColumnIdent childColumnName = this.aliasToColumnMapping.get(column);
        if (childColumnName == null) {
            if (column.isTopLevel()) {
                return null;
            }
            childColumnName = this.aliasToColumnMapping.get(column.getRoot());
            if (childColumnName == null) {
                ColumnIdent maybeQuotedSubscriptColumnAlias = new ColumnIdent(column.sqlFqn());
                childColumnName = this.aliasToColumnMapping.get(maybeQuotedSubscriptColumnAlias);
                if (childColumnName == null) {
                    return null;
                }
                column = maybeQuotedSubscriptColumnAlias;
            } else {
                childColumnName = new ColumnIdent(childColumnName.name(), column.path());
            }
        }
        if ((field = this.relation.getField(childColumnName, operation)) == null) {
            return null;
        }
        ScopedSymbol scopedSymbol = new ScopedSymbol(this.alias, column, field.valueType());
        int i = this.scopedSymbols.indexOf(scopedSymbol);
        if (i >= 0) {
            return this.scopedSymbols.get(i);
        }
        this.scopedSymbols.add(scopedSymbol);
        return scopedSymbol;
    }

    public AnalyzedRelation relation() {
        return this.relation;
    }

    @Override
    public RelationName relationName() {
        return this.alias;
    }

    @Override
    @Nonnull
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public String toString() {
        return this.relation + " AS " + this.alias;
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitAliasedAnalyzedRelation(this, context);
    }

    @Override
    @Nullable
    public Symbol resolveField(ScopedSymbol field) {
        if (!field.relation().equals(this.alias)) {
            throw new IllegalArgumentException(field + " does not belong to " + this.relationName());
        }
        ColumnIdent column = field.column();
        ColumnIdent childColumnName = this.aliasToColumnMapping.get(column);
        if (childColumnName == null && !column.isTopLevel()) {
            ColumnIdent childCol = this.aliasToColumnMapping.get(column.getRoot());
            childColumnName = new ColumnIdent(childCol.name(), column.path());
        }
        assert (childColumnName != null) : "If a ScopedSymbol has been retrieved via `getField`, it must be possible to get the columnIdent";
        Symbol result = this.relation.getField(childColumnName, Operation.READ);
        if (result == null) {
            throw new IllegalArgumentException(field + " does not belong to " + this.relationName());
        }
        return result;
    }
}

