/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.expressions;

import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.ColumnValidationException;
import io.crate.exceptions.ConversionException;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.DynamicReference;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.protocols.postgres.parser.PgArrayParsingException;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public final class ValueNormalizer {
    private ValueNormalizer() {
    }

    public static Symbol normalizeInputForReference(Symbol valueSymbol, Reference reference, TableInfo tableInfo, Function<Symbol, Symbol> normalizer) {
        assert (valueSymbol != null) : "valueSymbol must not be null";
        DataType<?> targetType = ValueNormalizer.getTargetType(valueSymbol, reference);
        try {
            valueSymbol = normalizer.apply(valueSymbol.cast(reference.valueType(), new CastMode[0]));
        }
        catch (ConversionException | PgArrayParsingException e) {
            throw new ColumnValidationException(reference.column().name(), tableInfo.ident(), String.format(Locale.ENGLISH, "Cannot cast expression `%s` of type `%s` to `%s`", valueSymbol, valueSymbol.valueType().getName(), reference.valueType().getName()));
        }
        if (!(valueSymbol instanceof Literal)) {
            return valueSymbol.cast(targetType, new CastMode[0]);
        }
        Object value = ((Literal)valueSymbol).value();
        if (value == null) {
            return valueSymbol;
        }
        try {
            if (targetType.id() == 12) {
                ValueNormalizer.normalizeObjectValue((Map)value, reference, tableInfo);
            } else if (ValueNormalizer.isObjectArray(targetType)) {
                ValueNormalizer.normalizeObjectArrayValue((List)value, reference, tableInfo);
            }
        }
        catch (ConversionException | PgArrayParsingException e) {
            throw new ColumnValidationException(reference.column().name(), tableInfo.ident(), Symbols.format("\"%s\" has a type that can't be implicitly cast to that of \"%s\" (" + reference.valueType().getName() + ")", valueSymbol, reference));
        }
        return valueSymbol;
    }

    private static DataType<?> getTargetType(Symbol valueSymbol, Reference reference) {
        DataType<?> targetType;
        if (reference instanceof DynamicReference) {
            targetType = valueSymbol.valueType();
            ((DynamicReference)reference).valueType(targetType);
        } else {
            targetType = reference.valueType();
        }
        return targetType;
    }

    private static void normalizeObjectValue(Map<String, Object> value, Reference info, TableInfo tableInfo) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            ColumnIdent nestedIdent = ColumnIdent.getChildSafe(info.column(), entry.getKey());
            Reference nestedInfo = tableInfo.getReference(nestedIdent);
            if (nestedInfo == null) {
                if (info.columnPolicy() == ColumnPolicy.IGNORED) continue;
                DynamicReference dynamicReference = null;
                if (tableInfo instanceof DocTableInfo) {
                    dynamicReference = ((DocTableInfo)tableInfo).getDynamic(nestedIdent, true);
                }
                if (dynamicReference == null) {
                    throw new ColumnUnknownException(nestedIdent.sqlFqn(), tableInfo.ident());
                }
                DataType<?> type = DataTypes.guessType(entry.getValue());
                if (type == null) {
                    throw new ColumnValidationException(info.column().sqlFqn(), tableInfo.ident(), "Invalid value");
                }
                dynamicReference.valueType(type);
                nestedInfo = dynamicReference;
            } else if (entry.getValue() == null) continue;
            if (nestedInfo.valueType().id() == 12 && entry.getValue() instanceof Map) {
                ValueNormalizer.normalizeObjectValue((Map)entry.getValue(), nestedInfo, tableInfo);
                continue;
            }
            if (ValueNormalizer.isObjectArray(nestedInfo.valueType()) && entry.getValue() instanceof List) {
                ValueNormalizer.normalizeObjectArrayValue((List)entry.getValue(), nestedInfo, tableInfo);
                continue;
            }
            entry.setValue(ValueNormalizer.normalizePrimitiveValue(entry.getValue(), nestedInfo));
        }
    }

    private static boolean isObjectArray(DataType type) {
        return type.id() == 100 && ((ArrayType)type).innerType().id() == 12;
    }

    private static void normalizeObjectArrayValue(List<Map<String, Object>> values, Reference arrayInfo, TableInfo tableInfo) {
        for (Map<String, Object> value : values) {
            ValueNormalizer.normalizeObjectValue(value, arrayInfo, tableInfo);
        }
    }

    private static Object normalizePrimitiveValue(Object primitiveValue, Reference info) {
        if (info.valueType().equals(DataTypes.STRING) && primitiveValue instanceof String) {
            return primitiveValue;
        }
        try {
            return info.valueType().sanitizeValue(primitiveValue);
        }
        catch (Exception e) {
            throw new ColumnValidationException(info.column().sqlFqn(), info.ident().tableIdent(), String.format(Locale.ENGLISH, "Invalid %s", info.valueType().getName()));
        }
    }
}

