/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.expressions;

import io.crate.analyze.relations.FieldProvider;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.QualifiedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class TableReferenceResolver
implements FieldProvider<Reference> {
    private final Collection<Reference> tableReferences;
    private final RelationName relationName;
    private final List<Reference> references = new ArrayList<Reference>();

    public TableReferenceResolver(Collection<Reference> tableReferences, RelationName relationName) {
        this.tableReferences = tableReferences;
        this.relationName = relationName;
    }

    public static ColumnIdent columnIdent(QualifiedName qualifiedName, @Nullable List<String> path) {
        List<String> qualifiedNameParts = qualifiedName.getParts();
        if (qualifiedNameParts.size() != 1) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column reference \"%s\" has too many parts. A column must not have a schema or a table here.", qualifiedName));
        }
        return new ColumnIdent(qualifiedNameParts.get(qualifiedNameParts.size() - 1), path);
    }

    @Override
    public Reference resolveField(QualifiedName qualifiedName, @Nullable List<String> path, Operation operation) {
        ColumnIdent columnIdent = TableReferenceResolver.columnIdent(qualifiedName, path);
        for (Reference reference : this.tableReferences) {
            if (!reference.column().equals(columnIdent)) continue;
            if (reference instanceof GeneratedReference) {
                throw new IllegalArgumentException("A generated column cannot be based on a generated column");
            }
            this.references.add(reference);
            return reference;
        }
        throw new ColumnUnknownException(columnIdent.sqlFqn(), this.relationName);
    }

    public List<Reference> references() {
        return this.references;
    }
}

