/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.expressions;

import io.crate.metadata.ColumnIdent;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.StringLiteral;
import io.crate.sql.tree.SubscriptExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class ExpressionToColumnIdentVisitor
extends AstVisitor<ColumnIdent, List<String>> {
    private static final ExpressionToColumnIdentVisitor INSTANCE = new ExpressionToColumnIdentVisitor();

    private ExpressionToColumnIdentVisitor() {
    }

    public static ColumnIdent convert(Node node) {
        return node.accept(INSTANCE, null);
    }

    @Override
    protected ColumnIdent visitQualifiedNameReference(QualifiedNameReference node, @Nullable List<String> context) {
        if (node.getName().getParts().size() > 1) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Qualified name references are not allowed to contain paths ('%s')", node.getName().toString()));
        }
        if (context != null) {
            return ColumnIdent.fromNameAndPathSafe(node.getName().toString(), context);
        }
        return ColumnIdent.fromNameSafe(node.getName().toString());
    }

    @Override
    protected ColumnIdent visitStringLiteral(StringLiteral node, List<String> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "String literal '%s' is not allowed as column identifier", node.getValue()));
        }
        ColumnIdent.validateObjectKey(node.getValue());
        context.add(node.getValue());
        return null;
    }

    @Override
    protected ColumnIdent visitSubscriptExpression(SubscriptExpression node, List<String> context) {
        if (node.index() instanceof QualifiedNameReference) {
            throw new IllegalArgumentException("Key of subscript must not be a reference");
        }
        if (context == null) {
            context = new ArrayList<String>();
        }
        ColumnIdent colIdent = node.base().accept(this, context);
        node.index().accept(this, context);
        return colIdent;
    }

    @Override
    protected ColumnIdent visitNode(Node node, List<String> context) {
        throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Can't handle %s.", node));
    }
}

