/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.expressions;

import com.google.common.collect.Lists;
import io.crate.analyze.DataTypeAnalyzer;
import io.crate.analyze.FrameBoundDefinition;
import io.crate.analyze.NegateLiterals;
import io.crate.analyze.OrderBy;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.SubscriptContext;
import io.crate.analyze.SubscriptValidator;
import io.crate.analyze.WindowDefinition;
import io.crate.analyze.WindowFrameDefinition;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.SubqueryAnalyzer;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.OrderyByAnalyzer;
import io.crate.analyze.validator.SemanticSortValidator;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.ConversionException;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.operator.LikeOperators;
import io.crate.expression.predicate.MatchPredicate;
import io.crate.expression.scalar.ExtractFunctions;
import io.crate.expression.scalar.SubscriptFunctions;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.WindowFunction;
import io.crate.interval.IntervalParser;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.FunctionType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.table.Operation;
import io.crate.sql.ExpressionFormatter;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.ArithmeticExpression;
import io.crate.sql.tree.ArrayComparison;
import io.crate.sql.tree.ArrayComparisonExpression;
import io.crate.sql.tree.ArrayLikePredicate;
import io.crate.sql.tree.ArrayLiteral;
import io.crate.sql.tree.ArraySubQueryExpression;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.BetweenPredicate;
import io.crate.sql.tree.BooleanLiteral;
import io.crate.sql.tree.Cast;
import io.crate.sql.tree.ComparisonExpression;
import io.crate.sql.tree.CurrentTime;
import io.crate.sql.tree.DoubleLiteral;
import io.crate.sql.tree.EscapedCharStringLiteral;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Extract;
import io.crate.sql.tree.FrameBound;
import io.crate.sql.tree.FunctionCall;
import io.crate.sql.tree.IfExpression;
import io.crate.sql.tree.InListExpression;
import io.crate.sql.tree.InPredicate;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.IntervalLiteral;
import io.crate.sql.tree.IsNotNullPredicate;
import io.crate.sql.tree.IsNullPredicate;
import io.crate.sql.tree.LikePredicate;
import io.crate.sql.tree.LogicalBinaryExpression;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.MatchPredicateColumnIdent;
import io.crate.sql.tree.NegativeExpression;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.NotExpression;
import io.crate.sql.tree.NullLiteral;
import io.crate.sql.tree.ObjectLiteral;
import io.crate.sql.tree.ParameterExpression;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.RecordSubscript;
import io.crate.sql.tree.SearchedCaseExpression;
import io.crate.sql.tree.SimpleCaseExpression;
import io.crate.sql.tree.StringLiteral;
import io.crate.sql.tree.SubqueryExpression;
import io.crate.sql.tree.SubscriptExpression;
import io.crate.sql.tree.TryCast;
import io.crate.sql.tree.WhenClause;
import io.crate.sql.tree.Window;
import io.crate.sql.tree.WindowFrame;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.UndefinedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.Period;

public class ExpressionAnalyzer {
    public static final Map<ComparisonExpression.Type, ComparisonExpression.Type> SWAP_OPERATOR_TABLE = Map.of(ComparisonExpression.Type.GREATER_THAN, ComparisonExpression.Type.LESS_THAN, ComparisonExpression.Type.LESS_THAN, ComparisonExpression.Type.GREATER_THAN, ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, ComparisonExpression.Type.LESS_THAN_OR_EQUAL, ComparisonExpression.Type.LESS_THAN_OR_EQUAL, ComparisonExpression.Type.GREATER_THAN_OR_EQUAL);
    private final CoordinatorTxnCtx coordinatorTxnCtx;
    private final ParamTypeHints paramTypeHints;
    private final FieldProvider<?> fieldProvider;
    @Nullable
    private final SubqueryAnalyzer subQueryAnalyzer;
    private final NodeContext nodeCtx;
    private final InnerExpressionAnalyzer innerAnalyzer;
    private final Operation operation;

    public ExpressionAnalyzer(CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, ParamTypeHints paramTypeHints, FieldProvider<?> fieldProvider, @Nullable SubqueryAnalyzer subQueryAnalyzer) {
        this(coordinatorTxnCtx, nodeCtx, paramTypeHints, fieldProvider, subQueryAnalyzer, Operation.READ);
    }

    public ExpressionAnalyzer(CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, ParamTypeHints paramTypeHints, FieldProvider<?> fieldProvider, @Nullable SubqueryAnalyzer subQueryAnalyzer, Operation operation) {
        this.nodeCtx = nodeCtx;
        this.coordinatorTxnCtx = coordinatorTxnCtx;
        this.paramTypeHints = paramTypeHints;
        this.fieldProvider = fieldProvider;
        this.subQueryAnalyzer = subQueryAnalyzer;
        this.innerAnalyzer = new InnerExpressionAnalyzer();
        this.operation = operation;
    }

    public Symbol convert(Expression expression, ExpressionAnalysisContext expressionAnalysisContext) {
        Symbol symbol = expression.accept(this.innerAnalyzer, expressionAnalysisContext);
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(this.nodeCtx, f -> expressionAnalysisContext.isEagerNormalizationAllowed() && f.isDeterministic());
        return normalizer.normalize(symbol, this.coordinatorTxnCtx);
    }

    public Symbol generateQuerySymbol(Optional<Expression> whereExpression, ExpressionAnalysisContext context) {
        return whereExpression.map(expression -> this.convert((Expression)expression, context)).orElse(Literal.BOOLEAN_TRUE);
    }

    private Symbol convertFunctionCall(FunctionCall node, ExpressionAnalysisContext context) {
        String name;
        ArrayList<Symbol> arguments = new ArrayList<Symbol>(node.getArguments().size());
        for (Expression expression2 : node.getArguments()) {
            Symbol argSymbol = expression2.accept(this.innerAnalyzer, context);
            arguments.add(argSymbol);
        }
        List<String> parts = node.getName().getParts();
        String schema = null;
        if (parts.size() == 1) {
            name = parts.get(0);
        } else {
            schema = parts.get(0);
            name = parts.get(1);
        }
        Symbol filter = node.filter().map(expression -> this.convert((Expression)expression, context)).orElse(null);
        WindowDefinition windowDefinition = this.getWindowDefinition(node.getWindow(), context);
        if (node.isDistinct()) {
            if (arguments.size() > 1) {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "%s(DISTINCT x) does not accept more than one argument", node.getName()));
            }
            Symbol collectSetFunction = ExpressionAnalyzer.allocateFunction("collect_set", arguments, filter, context, this.coordinatorTxnCtx, this.nodeCtx);
            String nodeName = "collection_" + name;
            List<Symbol> outerArguments = List.of(collectSetFunction);
            try {
                return this.allocateBuiltinOrUdfFunction(schema, nodeName, outerArguments, null, windowDefinition, context);
            }
            catch (UnsupportedOperationException ex) {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "unknown function %s(DISTINCT %s)", name, ((Symbol)arguments.get(0)).valueType()), ex);
            }
        }
        return this.allocateBuiltinOrUdfFunction(schema, name, arguments, filter, windowDefinition, context);
    }

    @Nullable
    private WindowDefinition getWindowDefinition(Optional<Window> maybeWindow, ExpressionAnalysisContext context) {
        Window window;
        if (!maybeWindow.isPresent()) {
            return null;
        }
        Window unresolvedWindow = maybeWindow.get();
        if (unresolvedWindow.windowRef() != null) {
            Window refWindow = this.resolveWindowRef(unresolvedWindow.windowRef(), context.windows());
            window = unresolvedWindow.merge(refWindow);
        } else {
            window = unresolvedWindow;
        }
        ArrayList<Symbol> partitionSymbols = new ArrayList<Symbol>(window.getPartitions().size());
        for (Expression partition : window.getPartitions()) {
            Symbol symbol = this.convert(partition, context);
            SemanticSortValidator.validate(symbol, "PARTITION BY");
            partitionSymbols.add(symbol);
        }
        OrderBy orderBy = OrderyByAnalyzer.analyzeSortItems(window.getOrderBy(), sortKey -> {
            Symbol symbol = this.convert((Expression)sortKey, context);
            SemanticSortValidator.validate(symbol);
            return symbol;
        });
        WindowFrameDefinition windowFrameDefinition = WindowDefinition.RANGE_UNBOUNDED_PRECEDING_CURRENT_ROW;
        if (window.getWindowFrame().isPresent()) {
            WindowFrame windowFrame = window.getWindowFrame().get();
            this.validateFrame(window, windowFrame);
            FrameBound start = windowFrame.getStart();
            FrameBoundDefinition startBound = this.convertToAnalyzedFrameBound(context, start);
            FrameBoundDefinition endBound = windowFrame.getEnd().map(end -> this.convertToAnalyzedFrameBound(context, (FrameBound)end)).orElse(new FrameBoundDefinition(FrameBound.Type.CURRENT_ROW, Literal.NULL));
            windowFrameDefinition = new WindowFrameDefinition(windowFrame.mode(), startBound, endBound);
        }
        return new WindowDefinition(partitionSymbols, orderBy, windowFrameDefinition);
    }

    private Window resolveWindowRef(@Nonnull String name, Map<String, Window> windows) {
        Window window = windows.get(name);
        if (window == null) {
            throw new IllegalArgumentException("Window " + name + " does not exist");
        }
        String windowRef = window.windowRef();
        while (windowRef != null) {
            Window refWindow = windows.get(windowRef);
            window = window.merge(refWindow);
            windowRef = refWindow.windowRef();
        }
        return window;
    }

    private void validateFrame(Window window, WindowFrame windowFrame) {
        FrameBound.Type startType = windowFrame.getStart().getType();
        if (startType.equals((Object)FrameBound.Type.FOLLOWING) || startType.equals((Object)FrameBound.Type.UNBOUNDED_FOLLOWING)) {
            throw new IllegalStateException("Frame start cannot be " + startType);
        }
        if (windowFrame.mode() == WindowFrame.Mode.RANGE && startType.equals((Object)FrameBound.Type.PRECEDING) && windowFrame.getStart().getValue() != null && window.getOrderBy().size() != 1) {
            throw new IllegalStateException("RANGE with offset PRECEDING/FOLLOWING requires exactly one ORDER BY column");
        }
        windowFrame.getEnd().ifPresent(frameBound -> {
            FrameBound.Type endType = frameBound.getType();
            if (endType.equals((Object)FrameBound.Type.PRECEDING) || endType.equals((Object)FrameBound.Type.UNBOUNDED_PRECEDING)) {
                throw new IllegalStateException("Frame end cannot be " + endType);
            }
            if (windowFrame.mode() == WindowFrame.Mode.RANGE && endType.equals((Object)FrameBound.Type.FOLLOWING) && windowFrame.getEnd().get().getValue() != null && window.getOrderBy().size() != 1) {
                throw new IllegalStateException("RANGE with offset PRECEDING/FOLLOWING requires exactly one ORDER BY column");
            }
        });
    }

    private FrameBoundDefinition convertToAnalyzedFrameBound(ExpressionAnalysisContext context, FrameBound frameBound) {
        Expression offsetExpression = frameBound.getValue();
        Literal<Object> offsetSymbol = offsetExpression == null ? Literal.NULL : this.convert(offsetExpression, context);
        return new FrameBoundDefinition(frameBound.getType(), offsetSymbol);
    }

    private static List<Symbol> cast(List<Symbol> symbolsToCast, List<DataType<?>> targetTypes) {
        if (symbolsToCast.size() != targetTypes.size()) {
            throw new IllegalStateException("Given symbol list has to match the target type list.");
        }
        int size = symbolsToCast.size();
        ArrayList<Symbol> castList = new ArrayList<Symbol>(size);
        for (int i = 0; i < size; ++i) {
            Symbol symbolToCast = symbolsToCast.get(i);
            DataType<?> targetType = targetTypes.get(i);
            if (targetType.id() == 0) {
                castList.add(symbolToCast);
                continue;
            }
            castList.add(symbolToCast.cast(targetType, new CastMode[0]));
        }
        return castList;
    }

    private Symbol allocateBuiltinOrUdfFunction(String schema, String functionName, List<Symbol> arguments, Symbol filter, WindowDefinition windowDefinition, ExpressionAnalysisContext context) {
        return ExpressionAnalyzer.allocateBuiltinOrUdfFunction(schema, functionName, arguments, filter, context, windowDefinition, this.coordinatorTxnCtx, this.nodeCtx);
    }

    private Symbol allocateFunction(String functionName, List<Symbol> arguments, ExpressionAnalysisContext context) {
        return ExpressionAnalyzer.allocateFunction(functionName, arguments, null, context, this.coordinatorTxnCtx, this.nodeCtx);
    }

    public static Symbol allocateFunction(String functionName, List<Symbol> arguments, Symbol filter, ExpressionAnalysisContext context, CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx) {
        return ExpressionAnalyzer.allocateBuiltinOrUdfFunction(null, functionName, arguments, filter, context, null, coordinatorTxnCtx, nodeCtx);
    }

    private static Symbol allocateBuiltinOrUdfFunction(@Nullable String schema, String functionName, List<Symbol> arguments, @Nullable Symbol filter, ExpressionAnalysisContext context, @Nullable WindowDefinition windowDefinition, CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx) {
        Function newFunction;
        FunctionImplementation funcImpl = nodeCtx.functions().get(schema, functionName, arguments, coordinatorTxnCtx.sessionContext().searchPath());
        Signature signature = funcImpl.signature();
        Signature boundSignature = funcImpl.boundSignature();
        List<Symbol> castArguments = ExpressionAnalyzer.cast(arguments, boundSignature.getArgumentDataTypes());
        if (windowDefinition == null) {
            if (signature.getKind() == FunctionType.AGGREGATE) {
                context.indicateAggregates();
            } else if (filter != null) {
                throw new UnsupportedOperationException("Only aggregate functions allow a FILTER clause");
            }
            newFunction = new Function(signature, castArguments, boundSignature.getReturnType().createType(), filter);
        } else {
            if (signature.getKind() != FunctionType.WINDOW && signature.getKind() != FunctionType.AGGREGATE) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "OVER clause was specified, but %s is neither a window nor an aggregate function.", functionName));
            }
            newFunction = new WindowFunction(signature, castArguments, boundSignature.getReturnType().createType(), filter, windowDefinition);
        }
        return newFunction;
    }

    private static void verifyTypesForMatch(Iterable<? extends Symbol> columns, DataType<?> columnType) {
        if (!MatchPredicate.SUPPORTED_TYPES.contains(columnType)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Can only use MATCH on columns of type STRING or GEO_SHAPE, not on '%s'", columnType));
        }
        for (Symbol symbol : columns) {
            if (symbol.valueType().equals(columnType)) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "All columns within a match predicate must be of the same type. Found %s and %s", columnType, symbol.valueType()));
        }
    }

    private static void ensureResultTypesMatch(Collection<? extends Symbol> results) {
        HashSet resultTypes = new HashSet(results.size());
        for (Symbol symbol : results) {
            resultTypes.add(symbol.valueType());
        }
        if (resultTypes.size() == 2 && !resultTypes.contains(DataTypes.UNDEFINED) || resultTypes.size() > 2) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Data types of all result expressions of a CASE statement must be equal, found: %s", results.stream().map(Symbol::valueType).collect(Collectors.toList())));
        }
    }

    @Nullable
    private static String detectAndSanitizeQuotedSubscript(String columnName) {
        int openSubscriptPos = columnName.indexOf("[");
        if (openSubscriptPos > -1) {
            return "\"" + columnName.substring(0, openSubscriptPos) + "\"" + columnName.substring(openSubscriptPos);
        }
        return null;
    }

    private class InnerExpressionAnalyzer
    extends AstVisitor<Symbol, ExpressionAnalysisContext> {
        private final Map<IntervalLiteral.IntervalField, IntervalParser.Precision> INTERVAL_FIELDS = Map.of(IntervalLiteral.IntervalField.YEAR, IntervalParser.Precision.YEAR, IntervalLiteral.IntervalField.MONTH, IntervalParser.Precision.MONTH, IntervalLiteral.IntervalField.DAY, IntervalParser.Precision.DAY, IntervalLiteral.IntervalField.HOUR, IntervalParser.Precision.HOUR, IntervalLiteral.IntervalField.MINUTE, IntervalParser.Precision.MINUTE, IntervalLiteral.IntervalField.SECOND, IntervalParser.Precision.SECOND);

        private InnerExpressionAnalyzer() {
        }

        @Override
        protected Symbol visitNode(Node node, ExpressionAnalysisContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Unsupported node %s", node));
        }

        @Override
        protected Symbol visitExpression(Expression node, ExpressionAnalysisContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Unsupported expression %s", ExpressionFormatter.formatStandaloneExpression(node)));
        }

        @Override
        protected Symbol visitCurrentTime(CurrentTime node, ExpressionAnalysisContext context) {
            String funcName = "current_timestamp";
            switch (node.getType()) {
                case TIMESTAMP: {
                    break;
                }
                case TIME: {
                    funcName = "current_time";
                    break;
                }
                default: {
                    this.visitExpression((Expression)node, context);
                }
            }
            Optional<Integer> p = node.getPrecision();
            return ExpressionAnalyzer.this.allocateFunction(funcName, p.isPresent() ? List.of(Literal.ofUnchecked(DataTypes.INTEGER, p.get())) : List.of(), context);
        }

        @Override
        protected Symbol visitIfExpression(IfExpression node, ExpressionAnalysisContext context) {
            Optional<Expression> defaultExpression = node.getFalseValue();
            ArrayList<Symbol> arguments = new ArrayList<Symbol>(defaultExpression.isPresent() ? 3 : 2);
            arguments.add(node.getCondition().accept(ExpressionAnalyzer.this.innerAnalyzer, context));
            arguments.add(node.getTrueValue().accept(ExpressionAnalyzer.this.innerAnalyzer, context));
            if (defaultExpression.isPresent()) {
                arguments.add(defaultExpression.get().accept(ExpressionAnalyzer.this.innerAnalyzer, context));
            }
            return ExpressionAnalyzer.this.allocateFunction("if", arguments, context);
        }

        @Override
        protected Symbol visitFunctionCall(FunctionCall node, ExpressionAnalysisContext context) {
            if (node.getName().toString().equalsIgnoreCase("subscript")) {
                assert (node.getArguments().size() == 2) : "Number of arguments for subscript function must be 2";
                return this.visitSubscriptExpression(new SubscriptExpression(node.getArguments().get(0), node.getArguments().get(1)), context);
            }
            return ExpressionAnalyzer.this.convertFunctionCall(node, context);
        }

        @Override
        protected Symbol visitSimpleCaseExpression(SimpleCaseExpression node, ExpressionAnalysisContext context) {
            List<WhenClause> whenClauses = node.getWhenClauses();
            ArrayList<Symbol> operands = new ArrayList<Symbol>(whenClauses.size());
            ArrayList<Symbol> results = new ArrayList<Symbol>(whenClauses.size());
            Symbol caseOperand = ExpressionAnalyzer.this.convert(node.getOperand(), context);
            for (WhenClause whenClause : whenClauses) {
                Symbol whenOperand = ExpressionAnalyzer.this.convert(whenClause.getOperand(), context);
                operands.add(ExpressionAnalyzer.this.allocateFunction("op_=", List.of(caseOperand, whenOperand), context));
                results.add(ExpressionAnalyzer.this.convert(whenClause.getResult(), context));
            }
            ExpressionAnalyzer.ensureResultTypesMatch(results);
            Expression defaultValue = node.getDefaultValue();
            return this.createChain(operands, results, defaultValue == null ? null : ExpressionAnalyzer.this.convert(defaultValue, context), context);
        }

        @Override
        protected Symbol visitSearchedCaseExpression(SearchedCaseExpression node, ExpressionAnalysisContext context) {
            List<WhenClause> whenClauses = node.getWhenClauses();
            ArrayList<Symbol> operands = new ArrayList<Symbol>(whenClauses.size());
            ArrayList<Symbol> results = new ArrayList<Symbol>(whenClauses.size());
            for (WhenClause whenClause : whenClauses) {
                operands.add(whenClause.getOperand().accept(ExpressionAnalyzer.this.innerAnalyzer, context));
                results.add(whenClause.getResult().accept(ExpressionAnalyzer.this.innerAnalyzer, context));
            }
            ExpressionAnalyzer.ensureResultTypesMatch(results);
            Expression defaultValue = node.getDefaultValue();
            return this.createChain(operands, results, defaultValue == null ? null : ExpressionAnalyzer.this.convert(defaultValue, context), context);
        }

        private Symbol createChain(List<Symbol> operands, List<Symbol> results, @Nullable Symbol defaultValueSymbol, ExpressionAnalysisContext context) {
            Symbol lastSymbol = defaultValueSymbol;
            for (int i = operands.size() - 1; i >= 0; --i) {
                Symbol operand = operands.get(i);
                Symbol result = results.get(i);
                ArrayList<Symbol> arguments = new ArrayList<Symbol>();
                arguments.add(operand);
                arguments.add(result);
                if (lastSymbol != null) {
                    arguments.add(lastSymbol);
                }
                lastSymbol = ExpressionAnalyzer.this.allocateFunction("if", arguments, context);
            }
            return lastSymbol;
        }

        @Override
        protected Symbol visitCast(Cast node, ExpressionAnalysisContext context) {
            DataType<?> returnType = DataTypeAnalyzer.convert(node.getType());
            return node.getExpression().accept(this, context).cast(returnType, CastMode.EXPLICIT);
        }

        @Override
        protected Symbol visitTryCast(TryCast node, ExpressionAnalysisContext context) {
            DataType<?> returnType = DataTypeAnalyzer.convert(node.getType());
            try {
                return node.getExpression().accept(this, context).cast(returnType, CastMode.EXPLICIT, CastMode.TRY);
            }
            catch (ConversionException e) {
                return Literal.NULL;
            }
        }

        @Override
        protected Symbol visitExtract(Extract node, ExpressionAnalysisContext context) {
            Symbol expression = node.getExpression().accept(this, context);
            return ExpressionAnalyzer.this.allocateFunction(ExtractFunctions.functionNameFrom(node.getField()), List.of(expression), context);
        }

        @Override
        protected Symbol visitInPredicate(InPredicate node, ExpressionAnalysisContext context) {
            Expression arrayExpression;
            Expression valueList = node.getValueList();
            if (valueList instanceof InListExpression) {
                List<Expression> expressions = ((InListExpression)valueList).getValues();
                arrayExpression = new ArrayLiteral(expressions);
            } else {
                arrayExpression = node.getValueList();
            }
            ArrayComparisonExpression arrayComparisonExpression = new ArrayComparisonExpression(ComparisonExpression.Type.EQUAL, ArrayComparison.Quantifier.ANY, node.getValue(), arrayExpression);
            return arrayComparisonExpression.accept(this, context);
        }

        @Override
        protected Symbol visitArraySubQueryExpression(ArraySubQueryExpression node, ExpressionAnalysisContext context) {
            SubqueryExpression subqueryExpression = node.subqueryExpression();
            context.registerArrayChild(subqueryExpression);
            return subqueryExpression.accept(this, context);
        }

        @Override
        protected Symbol visitIsNotNullPredicate(IsNotNullPredicate node, ExpressionAnalysisContext context) {
            Symbol argument = node.getValue().accept(this, context);
            return ExpressionAnalyzer.this.allocateFunction("op_not", List.of(ExpressionAnalyzer.this.allocateFunction("op_isnull", List.of(argument), context)), context);
        }

        @Override
        protected Symbol visitSubscriptExpression(SubscriptExpression node, ExpressionAnalysisContext context) {
            Object name;
            SubscriptContext subscriptContext = new SubscriptContext();
            SubscriptValidator.validate(node, subscriptContext);
            QualifiedName qualifiedName = subscriptContext.qualifiedName();
            List<String> parts = subscriptContext.parts();
            if (qualifiedName == null) {
                Symbol base = node.base().accept(this, context);
                Symbol index = node.index().accept(this, context);
                return ExpressionAnalyzer.this.allocateFunction("subscript", List.of(base, index), context);
            }
            String columnName = qualifiedName.getSuffix();
            String maybeQuotedSubscript = ExpressionAnalyzer.detectAndSanitizeQuotedSubscript(columnName);
            if (maybeQuotedSubscript != null) {
                SubscriptExpression subscript = (SubscriptExpression)SqlParser.createExpression(maybeQuotedSubscript);
                return this.visitSubscriptExpression(new SubscriptExpression(subscript, node.index()), context);
            }
            try {
                name = ExpressionAnalyzer.this.fieldProvider.resolveField(qualifiedName, parts, ExpressionAnalyzer.this.operation);
            }
            catch (ColumnUnknownException e) {
                if (ExpressionAnalyzer.this.operation != Operation.READ) {
                    throw e;
                }
                try {
                    Object base = ExpressionAnalyzer.this.fieldProvider.resolveField(qualifiedName, List.of(), ExpressionAnalyzer.this.operation);
                    if (base instanceof Reference) {
                        throw e;
                    }
                    return ExpressionAnalyzer.this.allocateFunction("subscript", List.of(node.base().accept(this, context), node.index().accept(this, context)), context);
                }
                catch (ColumnUnknownException e2) {
                    throw e;
                }
            }
            Expression idxExpression = subscriptContext.index();
            if (idxExpression != null) {
                Symbol index = idxExpression.accept(this, context);
                return ExpressionAnalyzer.this.allocateFunction("subscript", List.of(name, index), context);
            }
            return name;
        }

        @Override
        protected Symbol visitLogicalBinaryExpression(LogicalBinaryExpression node, ExpressionAnalysisContext context) {
            String name = switch (node.getType()) {
                case LogicalBinaryExpression.Type.AND -> "op_and";
                case LogicalBinaryExpression.Type.OR -> "op_or";
                default -> throw new UnsupportedOperationException("Unsupported logical binary expression " + node.getType().name());
            };
            List<Symbol> arguments = List.of(node.getLeft().accept(this, context), node.getRight().accept(this, context));
            return ExpressionAnalyzer.this.allocateFunction(name, arguments, context);
        }

        @Override
        protected Symbol visitNotExpression(NotExpression node, ExpressionAnalysisContext context) {
            Symbol argument = node.getValue().accept(this, context);
            return ExpressionAnalyzer.this.allocateFunction("op_not", List.of(argument), context);
        }

        @Override
        protected Symbol visitComparisonExpression(ComparisonExpression node, ExpressionAnalysisContext context) {
            Symbol left = node.getLeft().accept(this, context);
            Symbol right = node.getRight().accept(this, context);
            Comparison comparison = new Comparison(ExpressionAnalyzer.this.coordinatorTxnCtx, ExpressionAnalyzer.this.nodeCtx, node.getType(), left, right);
            comparison.normalize(context);
            return ExpressionAnalyzer.this.allocateFunction(comparison.operatorName, comparison.arguments(), context);
        }

        @Override
        public Symbol visitArrayComparisonExpression(ArrayComparisonExpression node, ExpressionAnalysisContext context) {
            context.registerArrayChild(node.getRight());
            Symbol leftSymbol = node.getLeft().accept(this, context);
            Symbol arraySymbol = node.getRight().accept(this, context);
            ComparisonExpression.Type operationType = node.getType();
            return ExpressionAnalyzer.this.allocateFunction(switch (node.quantifier()) {
                case ArrayComparison.Quantifier.ANY -> "any_" + operationType.getValue();
                case ArrayComparison.Quantifier.ALL -> "_all_" + operationType.getValue();
                default -> throw new IllegalStateException("Expected comparison quantifier ALL or ANY, got " + node.quantifier());
            }, List.of(leftSymbol, arraySymbol), context);
        }

        @Override
        public Symbol visitArrayLikePredicate(ArrayLikePredicate node, ExpressionAnalysisContext context) {
            if (node.getEscape() != null) {
                throw new UnsupportedOperationException("ESCAPE is not supported.");
            }
            Symbol arraySymbol = node.getValue().accept(this, context);
            Symbol leftSymbol = node.getPattern().accept(this, context);
            return ExpressionAnalyzer.this.allocateFunction(LikeOperators.arrayOperatorName(node.inverse(), node.ignoreCase()), List.of(leftSymbol, arraySymbol), context);
        }

        @Override
        protected Symbol visitLikePredicate(LikePredicate node, ExpressionAnalysisContext context) {
            if (node.getEscape() != null) {
                throw new UnsupportedOperationException("ESCAPE is not supported.");
            }
            Symbol expression = node.getValue().accept(this, context);
            Symbol pattern = node.getPattern().accept(this, context);
            return ExpressionAnalyzer.this.allocateFunction(LikeOperators.arrayOperatorName(node.ignoreCase()), List.of(expression, pattern), context);
        }

        @Override
        protected Symbol visitIsNullPredicate(IsNullPredicate node, ExpressionAnalysisContext context) {
            Symbol value = node.getValue().accept(this, context);
            return ExpressionAnalyzer.this.allocateFunction("op_isnull", List.of(value), context);
        }

        @Override
        protected Symbol visitNegativeExpression(NegativeExpression node, ExpressionAnalysisContext context) {
            Symbol value = node.getValue().accept(this, context);
            Symbol returnSymbol = NegateLiterals.negate(value);
            if (returnSymbol != null) {
                return returnSymbol;
            }
            return ExpressionAnalyzer.this.allocateFunction("_negate", List.of(value), context);
        }

        @Override
        protected Symbol visitArithmeticExpression(ArithmeticExpression node, ExpressionAnalysisContext context) {
            Symbol left = node.getLeft().accept(this, context);
            Symbol right = node.getRight().accept(this, context);
            return ExpressionAnalyzer.this.allocateFunction(node.getType().name().toLowerCase(Locale.ENGLISH), List.of(left, right), context);
        }

        @Override
        public Symbol visitRecordSubscript(RecordSubscript recordSubscript, ExpressionAnalysisContext context) {
            Expression base = recordSubscript.base();
            String field = recordSubscript.field();
            ArrayList<String> reversedPath = new ArrayList<String>();
            reversedPath.add(field);
            while (base instanceof RecordSubscript) {
                RecordSubscript subscript = (RecordSubscript)base;
                base = subscript.base();
                reversedPath.add(subscript.field());
            }
            List path = Lists.reverse(reversedPath);
            if (base instanceof QualifiedNameReference) {
                QualifiedName name = ((QualifiedNameReference)base).getName();
                try {
                    return ExpressionAnalyzer.this.fieldProvider.resolveField(name, path, ExpressionAnalyzer.this.operation);
                }
                catch (ColumnUnknownException e) {
                    Object baseSymbol = ExpressionAnalyzer.this.fieldProvider.resolveField(name, List.of(), ExpressionAnalyzer.this.operation);
                    Function subscriptFunction = SubscriptFunctions.tryCreateSubscript(baseSymbol, path);
                    if (subscriptFunction == null) {
                        throw e;
                    }
                    return subscriptFunction;
                }
            }
            Symbol baseSymbol = base.accept(this, context);
            Function subscriptFunction = SubscriptFunctions.tryCreateSubscript(baseSymbol, path);
            if (subscriptFunction == null) {
                throw new UnsupportedOperationException("Unsupported expression `" + ExpressionFormatter.formatStandaloneExpression(recordSubscript) + "`, `" + ExpressionFormatter.formatStandaloneExpression(base) + "` should have type `object` or `record` but was `" + baseSymbol.valueType().getName() + "`");
            }
            return subscriptFunction;
        }

        @Override
        protected Symbol visitQualifiedNameReference(QualifiedNameReference node, ExpressionAnalysisContext context) {
            QualifiedName qualifiedName = node.getName();
            List<String> parts = qualifiedName.getParts();
            String columnName = parts.get(parts.size() - 1);
            String maybeQuotedSubscript = ExpressionAnalyzer.detectAndSanitizeQuotedSubscript(columnName);
            if (maybeQuotedSubscript != null) {
                SubscriptExpression subscript = (SubscriptExpression)SqlParser.createExpression(maybeQuotedSubscript);
                return this.visitSubscriptExpression(subscript, context);
            }
            return ExpressionAnalyzer.this.fieldProvider.resolveField(node.getName(), null, ExpressionAnalyzer.this.operation);
        }

        @Override
        protected Symbol visitBooleanLiteral(BooleanLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        @Override
        protected Symbol visitStringLiteral(StringLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        @Override
        protected Symbol visitEscapedCharStringLiteral(EscapedCharStringLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        @Override
        protected Symbol visitDoubleLiteral(DoubleLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        @Override
        protected Symbol visitLongLiteral(LongLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        @Override
        protected Symbol visitIntegerLiteral(IntegerLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        @Override
        protected Symbol visitNullLiteral(NullLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(UndefinedType.INSTANCE, null);
        }

        @Override
        public Symbol visitArrayLiteral(ArrayLiteral node, ExpressionAnalysisContext context) {
            List<Expression> values = node.values();
            if (values.isEmpty()) {
                return Literal.of(new ArrayType<Object>(UndefinedType.INSTANCE), List.of());
            }
            ArrayList<Symbol> arguments = new ArrayList<Symbol>(values.size());
            for (Expression value : values) {
                arguments.add(value.accept(this, context));
            }
            return ExpressionAnalyzer.this.allocateFunction("_array", arguments, context);
        }

        @Override
        public Symbol visitObjectLiteral(ObjectLiteral node, ExpressionAnalysisContext context) {
            Map<String, Expression> values = node.values();
            if (values.isEmpty()) {
                return Literal.EMPTY_OBJECT;
            }
            ArrayList<Symbol> arguments = new ArrayList<Symbol>(values.size() * 2);
            for (Map.Entry<String, Expression> entry : values.entrySet()) {
                arguments.add(Literal.of(entry.getKey()));
                arguments.add(entry.getValue().accept(this, context));
            }
            return ExpressionAnalyzer.this.allocateFunction("_map", arguments, context);
        }

        @Override
        public Symbol visitIntervalLiteral(IntervalLiteral node, ExpressionAnalysisContext context) {
            String value = node.getValue();
            IntervalParser.Precision start = this.INTERVAL_FIELDS.get((Object)node.getStartField());
            IntervalParser.Precision end = node.getEndField() == null ? null : this.INTERVAL_FIELDS.get((Object)node.getEndField());
            Period period = IntervalParser.apply(value, start, end);
            if (node.getSign() == IntervalLiteral.Sign.MINUS) {
                period = period.negated();
            }
            return Literal.newInterval(period);
        }

        @Override
        public Symbol visitParameterExpression(ParameterExpression node, ExpressionAnalysisContext context) {
            return ExpressionAnalyzer.this.paramTypeHints.apply(node);
        }

        @Override
        protected Symbol visitBetweenPredicate(BetweenPredicate node, ExpressionAnalysisContext context) {
            Symbol value = node.getValue().accept(this, context);
            Symbol min = node.getMin().accept(this, context);
            Symbol max = node.getMax().accept(this, context);
            Comparison gte = new Comparison(ExpressionAnalyzer.this.coordinatorTxnCtx, ExpressionAnalyzer.this.nodeCtx, ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, value, min);
            Comparison normalizedGte = gte.normalize(context);
            Symbol gteFunc = ExpressionAnalyzer.this.allocateFunction(normalizedGte.operatorName, normalizedGte.arguments(), context);
            Comparison lte = new Comparison(ExpressionAnalyzer.this.coordinatorTxnCtx, ExpressionAnalyzer.this.nodeCtx, ComparisonExpression.Type.LESS_THAN_OR_EQUAL, value, max);
            Comparison normalizedLte = lte.normalize(context);
            Symbol lteFunc = ExpressionAnalyzer.this.allocateFunction(normalizedLte.operatorName, normalizedLte.arguments(), context);
            return ExpressionAnalyzer.this.allocateFunction("op_and", List.of(gteFunc, lteFunc), context);
        }

        @Override
        public Symbol visitMatchPredicate(io.crate.sql.tree.MatchPredicate node, ExpressionAnalysisContext context) {
            HashMap<Symbol, Symbol> identBoostMap = new HashMap<Symbol, Symbol>(node.idents().size());
            DataType<?> columnType = null;
            HashSet<RelationName> relationsInColumns = new HashSet<RelationName>();
            for (MatchPredicateColumnIdent ident : node.idents()) {
                Symbol column = ident.columnIdent().accept(this, context);
                if (columnType == null) {
                    columnType = column.valueType();
                }
                if (!(column instanceof ScopedSymbol) && !(column instanceof Reference)) {
                    throw new IllegalArgumentException(Symbols.format("can only MATCH on columns, not on %s", column));
                }
                Symbol boost = ident.boost().accept(this, context);
                identBoostMap.put(column, boost);
                if (!(column instanceof ScopedSymbol)) continue;
                relationsInColumns.add(((ScopedSymbol)column).relation());
            }
            if (relationsInColumns.size() > 1) {
                throw new IllegalArgumentException("Cannot use MATCH predicates on columns of 2 different relations");
            }
            assert (columnType != null) : "columnType must not be null";
            ExpressionAnalyzer.verifyTypesForMatch(identBoostMap.keySet(), columnType);
            Symbol queryTerm = node.value().accept(this, context).cast(columnType, new CastMode[0]);
            String matchType = MatchPredicate.getMatchType(node.matchType(), columnType);
            ArrayList<Symbol> mapArgs = new ArrayList<Symbol>(node.properties().size() * 2);
            for (Map.Entry entry : node.properties().properties().entrySet()) {
                mapArgs.add(Literal.of((String)entry.getKey()));
                mapArgs.add(((Expression)entry.getValue()).accept(this, context));
            }
            Literal<Map<String, Object>> options = mapArgs.isEmpty() ? Literal.of(Map.of()) : ExpressionAnalyzer.this.allocateFunction("_map", mapArgs, context);
            return new io.crate.expression.symbol.MatchPredicate(identBoostMap, queryTerm, matchType, options);
        }

        @Override
        protected Symbol visitSubqueryExpression(SubqueryExpression node, ExpressionAnalysisContext context) {
            if (ExpressionAnalyzer.this.subQueryAnalyzer == null) {
                throw new UnsupportedOperationException("Subquery not supported in this statement");
            }
            AnalyzedRelation relation = ExpressionAnalyzer.this.subQueryAnalyzer.analyze(node.getQuery());
            List<Symbol> fields = relation.outputs();
            if (fields.size() > 1) {
                throw new UnsupportedOperationException("Subqueries with more than 1 column are not supported.");
            }
            DataType<?> innerType = fields.get(0).valueType();
            ArrayType dataType = new ArrayType(innerType);
            SelectSymbol.ResultType resultType = context.isArrayChild(node) ? SelectSymbol.ResultType.SINGLE_COLUMN_MULTIPLE_VALUES : SelectSymbol.ResultType.SINGLE_COLUMN_SINGLE_VALUE;
            return new SelectSymbol(relation, dataType, resultType);
        }
    }

    private static class Comparison {
        private final CoordinatorTxnCtx coordinatorTxnCtx;
        private final NodeContext nodeCtx;
        private ComparisonExpression.Type comparisonExpressionType;
        private Symbol left;
        private Symbol right;
        private String operatorName;

        private Comparison(CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, ComparisonExpression.Type comparisonExpressionType, Symbol left, Symbol right) {
            this.coordinatorTxnCtx = coordinatorTxnCtx;
            this.nodeCtx = nodeCtx;
            this.operatorName = "op_" + comparisonExpressionType.getValue();
            this.comparisonExpressionType = comparisonExpressionType;
            this.left = left;
            this.right = right;
        }

        Comparison normalize(ExpressionAnalysisContext context) {
            this.swapIfNecessary();
            this.rewriteNegatingOperators(context);
            return this;
        }

        private void swapIfNecessary() {
            if ((!(this.right instanceof Reference) && !(this.right instanceof ScopedSymbol) || this.left instanceof Reference || this.left instanceof ScopedSymbol) && this.left.valueType().id() != DataTypes.UNDEFINED.id()) {
                return;
            }
            ComparisonExpression.Type type = SWAP_OPERATOR_TABLE.get((Object)this.comparisonExpressionType);
            if (type != null) {
                this.comparisonExpressionType = type;
                this.operatorName = "op_" + type.getValue();
            }
            Symbol tmp = this.left;
            this.left = this.right;
            this.right = tmp;
        }

        private void rewriteNegatingOperators(ExpressionAnalysisContext context) {
            String opName;
            switch (this.comparisonExpressionType) {
                case NOT_EQUAL: {
                    opName = "op_=";
                    break;
                }
                case REGEX_NO_MATCH: {
                    opName = "op_~";
                    break;
                }
                case REGEX_NO_MATCH_CI: {
                    opName = "op_~*";
                    break;
                }
                default: {
                    return;
                }
            }
            this.left = ExpressionAnalyzer.allocateFunction(opName, List.of(this.left, this.right), null, context, this.coordinatorTxnCtx, this.nodeCtx);
            this.right = null;
            this.operatorName = "op_not";
        }

        List<Symbol> arguments() {
            if (this.right == null) {
                return List.of(this.left);
            }
            return List.of(this.left, this.right);
        }
    }
}

