/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.copy;

import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.node.DiscoveryNode;

public class NodeFilters
implements Predicate<DiscoveryNode> {
    public static final String NAME = "node_filters";
    private final Predicate<DiscoveryNode> innerPredicate;

    public static NodeFilters fromMap(Map map) {
        String name = NodeFilters.stringOrIllegalArgument(map, "name");
        String id = NodeFilters.stringOrIllegalArgument(map, "id");
        if (!map.isEmpty()) {
            throw new IllegalArgumentException("Invalid node_filters arguments: " + map.keySet());
        }
        return new NodeFilters(name, id);
    }

    private static String stringOrIllegalArgument(Map map, String key) {
        Object obj = map.remove(key);
        try {
            return (String)obj;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "%s argument '%s' must be a String, not %s (%s)", NAME, key, obj, obj.getClass().getSimpleName()));
        }
    }

    NodeFilters(@Nullable String name, @Nullable String id) {
        if (name == null && id == null) {
            this.innerPredicate = discoveryNode -> true;
        } else {
            NamesPredicate namesPredicate = name == null ? discoveryNode -> true : new NamesPredicate(name);
            IdsPredicate idsPredicate = id == null ? discoveryNode -> true : new IdsPredicate(id);
            this.innerPredicate = namesPredicate.and(idsPredicate);
        }
    }

    @Override
    public boolean test(@Nullable DiscoveryNode discoveryNode) {
        return this.innerPredicate.test(discoveryNode);
    }

    private static class NamesPredicate
    implements Predicate<DiscoveryNode> {
        private final Pattern name;

        private NamesPredicate(String name) {
            this.name = Pattern.compile(name);
        }

        @Override
        public boolean test(@Nullable DiscoveryNode discoveryNode) {
            return discoveryNode != null && this.name.matcher(discoveryNode.getName()).matches();
        }
    }

    private static class IdsPredicate
    implements Predicate<DiscoveryNode> {
        private final Pattern id;

        private IdsPredicate(String id) {
            this.id = Pattern.compile(id);
        }

        @Override
        public boolean test(@Nullable DiscoveryNode discoveryNode) {
            return discoveryNode != null && this.id.matcher(discoveryNode.getId()).matches();
        }
    }
}

