/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.data.Input;
import io.crate.exceptions.VersioninigValidationException;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.doc.DocSysColumns;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class WhereClause {
    public static final WhereClause MATCH_ALL = new WhereClause(null);
    public static final WhereClause NO_MATCH = new WhereClause(Literal.BOOLEAN_FALSE);
    @Nullable
    private final Symbol query;
    private final Set<Symbol> clusteredBy;
    private final List<String> partitions;

    public static boolean canMatch(Symbol query) {
        if (query instanceof Input) {
            Object value = ((Input)((Object)query)).value();
            if (value == null) {
                return false;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new IllegalArgumentException("Expected query value to be of type `Boolean`, but got: " + value);
        }
        return true;
    }

    public WhereClause(@Nullable Symbol query) {
        this.query = query;
        this.partitions = List.of();
        this.clusteredBy = Set.of();
    }

    public WhereClause(@Nullable Symbol normalizedQuery, @Nullable List<String> partitions, Set<Symbol> clusteredBy) {
        this.clusteredBy = clusteredBy;
        this.partitions = Objects.requireNonNullElse(partitions, List.of());
        this.query = normalizedQuery;
        if (normalizedQuery != null) {
            WhereClause.validateVersioningColumnsUsage(normalizedQuery);
        }
    }

    public boolean hasQuery() {
        return this.query != null;
    }

    @Nullable
    public Symbol query() {
        return this.query;
    }

    public Symbol queryOrFallback() {
        return this.query == null ? Literal.BOOLEAN_TRUE : this.query;
    }

    public static void validateVersioningColumnsUsage(Symbol query) {
        if (Symbols.containsColumn(query, DocSysColumns.SEQ_NO)) {
            if (!Symbols.containsColumn(query, DocSysColumns.PRIMARY_TERM)) {
                throw VersioninigValidationException.seqNoAndPrimaryTermUsage();
            }
            if (Symbols.containsColumn(query, DocSysColumns.VERSION)) {
                throw VersioninigValidationException.mixedVersioningMeachanismsUsage();
            }
        } else if (Symbols.containsColumn(query, DocSysColumns.PRIMARY_TERM)) {
            if (!Symbols.containsColumn(query, DocSysColumns.SEQ_NO)) {
                throw VersioninigValidationException.seqNoAndPrimaryTermUsage();
            }
            if (Symbols.containsColumn(query, DocSysColumns.VERSION)) {
                throw VersioninigValidationException.mixedVersioningMeachanismsUsage();
            }
        }
    }

    public Set<Symbol> clusteredBy() {
        return this.clusteredBy;
    }

    @Nullable
    public Set<String> routingValues() {
        if (!this.clusteredBy.isEmpty()) {
            HashSet<String> result = new HashSet<String>(this.clusteredBy.size());
            for (Symbol symbol : this.clusteredBy) {
                assert (symbol instanceof Literal) : "clustered by symbols must be literals";
                result.add(((Literal)symbol).value().toString());
            }
            return result;
        }
        return null;
    }

    public List<String> partitions() {
        return this.partitions;
    }

    public String toString() {
        return "WhereClause{clusteredBy=" + this.clusteredBy + ", partitions=" + this.partitions + ", query=" + this.query + "}";
    }

    public boolean hasVersions() {
        return Symbols.containsColumn(this.query, DocSysColumns.VERSION);
    }

    public boolean hasSeqNoAndPrimaryTerm() {
        return Symbols.containsColumn(this.query, DocSysColumns.SEQ_NO) && Symbols.containsColumn(this.query, DocSysColumns.PRIMARY_TERM);
    }

    public WhereClause add(Symbol otherQuery) {
        if (this.query == null || this.query.equals(Literal.BOOLEAN_TRUE)) {
            return new WhereClause(otherQuery, this.partitions, this.clusteredBy);
        }
        if (WhereClause.canMatch(this.query)) {
            return new WhereClause(AndOperator.of(this.query, otherQuery), this.partitions, this.clusteredBy);
        }
        return this;
    }

    public WhereClause map(Function<? super Symbol, ? extends Symbol> mapper) {
        if (this.query == null && this.clusteredBy.isEmpty()) {
            return this;
        }
        Symbol newQuery = this.query == null ? null : mapper.apply(this.query);
        HashSet<Symbol> newClusteredBy = new HashSet<Symbol>(this.clusteredBy.size());
        for (Symbol symbol : this.clusteredBy) {
            newClusteredBy.add(mapper.apply(symbol));
        }
        return new WhereClause(newQuery, this.partitions, newClusteredBy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhereClause that = (WhereClause)o;
        return Objects.equals(this.clusteredBy, that.clusteredBy) && Objects.equals(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.clusteredBy, this.partitions);
    }
}

