/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedUpdateStatement;
import io.crate.analyze.MaybeAliasedStatement;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.SubqueryAnalyzer;
import io.crate.analyze.expressions.ValueNormalizer;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.FullQualifiedNameFieldProvider;
import io.crate.analyze.relations.NameFieldProvider;
import io.crate.analyze.relations.RelationAnalysisContext;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.analyze.relations.StatementAnalysisContext;
import io.crate.analyze.relations.select.SelectAnalysis;
import io.crate.analyze.relations.select.SelectAnalyzer;
import io.crate.common.collections.Lists2;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.SubscriptExpression;
import io.crate.sql.tree.Update;
import io.crate.types.ArrayType;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Predicate;

public final class UpdateAnalyzer {
    private static final Predicate<Reference> IS_OBJECT_ARRAY = input -> input.valueType().id() == 100 && ((ArrayType)input.valueType()).innerType().id() == 12;
    private final NodeContext nodeCtx;
    private final RelationAnalyzer relationAnalyzer;

    UpdateAnalyzer(NodeContext nodeCtx, RelationAnalyzer relationAnalyzer) {
        this.nodeCtx = nodeCtx;
        this.relationAnalyzer = relationAnalyzer;
    }

    public AnalyzedUpdateStatement analyze(Update update, ParamTypeHints typeHints, CoordinatorTxnCtx txnCtx) {
        StatementAnalysisContext stmtCtx = new StatementAnalysisContext(typeHints, Operation.UPDATE, txnCtx);
        RelationAnalysisContext relCtx = stmtCtx.startRelation();
        AnalyzedRelation relation = this.relationAnalyzer.analyze(update.relation(), stmtCtx);
        stmtCtx.endRelation();
        MaybeAliasedStatement maybeAliasedStatement = MaybeAliasedStatement.analyze(relation);
        relation = maybeAliasedStatement.nonAliasedRelation();
        if (!(relation instanceof AbstractTableRelation)) {
            throw new UnsupportedOperationException("UPDATE is only supported on base-tables");
        }
        AbstractTableRelation table = (AbstractTableRelation)relation;
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(this.nodeCtx, RowGranularity.CLUSTER, null, table);
        SubqueryAnalyzer subqueryAnalyzer = new SubqueryAnalyzer(this.relationAnalyzer, new StatementAnalysisContext(typeHints, Operation.READ, txnCtx));
        ExpressionAnalyzer sourceExprAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, new FullQualifiedNameFieldProvider(relCtx.sources(), relCtx.parentSources(), txnCtx.sessionContext().searchPath().currentSchema()), subqueryAnalyzer);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
        HashMap<Reference, Symbol> assignmentByTargetCol = this.getAssignments(update.assignments(), typeHints, txnCtx, table, normalizer, subqueryAnalyzer, sourceExprAnalyzer, exprCtx);
        Symbol query = Objects.requireNonNullElse(sourceExprAnalyzer.generateQuerySymbol(update.whereClause(), exprCtx), Literal.BOOLEAN_TRUE);
        query = maybeAliasedStatement.maybeMapFields(query);
        Symbol normalizedQuery = normalizer.normalize(query, txnCtx);
        SelectAnalysis selectAnalysis = SelectAnalyzer.analyzeSelectItems(update.returningClause(), relCtx.sources(), sourceExprAnalyzer, exprCtx);
        List<Symbol> outputSymbol = Lists2.map(selectAnalysis.outputSymbols(), x -> normalizer.normalize((Symbol)x, txnCtx));
        return new AnalyzedUpdateStatement(table, assignmentByTargetCol, normalizedQuery, outputSymbol.isEmpty() ? null : outputSymbol);
    }

    private HashMap<Reference, Symbol> getAssignments(List<Assignment<Expression>> assignments, ParamTypeHints typeHints, CoordinatorTxnCtx txnCtx, AbstractTableRelation<?> table, EvaluatingNormalizer normalizer, SubqueryAnalyzer subqueryAnalyzer, ExpressionAnalyzer sourceExprAnalyzer, ExpressionAnalysisContext exprCtx) {
        HashMap<Reference, Symbol> assignmentByTargetCol = new HashMap<Reference, Symbol>();
        ExpressionAnalyzer targetExprAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, new NameFieldProvider(table), subqueryAnalyzer, Operation.UPDATE);
        assert (assignments instanceof RandomAccess) : "assignments should implement RandomAccess for indexed loop to avoid iterator allocations";
        Object tableInfo = table.tableInfo();
        for (int i = 0; i < assignments.size(); ++i) {
            Assignment<Expression> assignment = assignments.get(i);
            AssignmentNameValidator.ensureNoArrayElementUpdate(assignment.columnName());
            Symbol target = normalizer.normalize(targetExprAnalyzer.convert(assignment.columnName(), exprCtx), txnCtx);
            assert (target instanceof Reference) : "AstBuilder restricts left side of assignments to Columns/Subscripts";
            Reference targetCol = (Reference)target;
            if (UpdateAnalyzer.hasMatchingParent(tableInfo, targetCol, IS_OBJECT_ARRAY)) {
                throw new IllegalArgumentException("Updating fields of object arrays is not supported");
            }
            Symbol source = ValueNormalizer.normalizeInputForReference(normalizer.normalize(sourceExprAnalyzer.convert(assignment.expression(), exprCtx), txnCtx), targetCol, tableInfo, s -> normalizer.normalize((Symbol)s, txnCtx));
            if (assignmentByTargetCol.put(targetCol, source) == null) continue;
            throw new IllegalArgumentException("Target expression repeated: " + targetCol.column().sqlFqn());
        }
        return assignmentByTargetCol;
    }

    private static boolean hasMatchingParent(TableInfo tableInfo, Reference info, Predicate<Reference> parentMatchPredicate) {
        for (ColumnIdent parent = info.column().getParent(); parent != null; parent = parent.getParent()) {
            Reference parentInfo = tableInfo.getReference(parent);
            if (!parentMatchPredicate.test(parentInfo)) continue;
            return true;
        }
        return false;
    }

    private static class AssignmentNameValidator
    extends AstVisitor<Void, Boolean> {
        private static final AssignmentNameValidator INSTANCE = new AssignmentNameValidator();

        private AssignmentNameValidator() {
        }

        static void ensureNoArrayElementUpdate(Expression expression) {
            expression.accept(INSTANCE, false);
        }

        @Override
        protected Void visitSubscriptExpression(SubscriptExpression node, Boolean childOfSubscript) {
            node.index().accept(this, true);
            return (Void)super.visitSubscriptExpression(node, childOfSubscript);
        }

        private Void validateLiteral(Boolean childOfSubscript) {
            if (childOfSubscript.booleanValue()) {
                throw new IllegalArgumentException("Updating a single element of an array is not supported");
            }
            return null;
        }

        @Override
        protected Void visitLongLiteral(LongLiteral node, Boolean childOfSubscript) {
            return this.validateLiteral(childOfSubscript);
        }

        @Override
        protected Void visitIntegerLiteral(IntegerLiteral node, Boolean childOfSubscript) {
            return this.validateLiteral(childOfSubscript);
        }
    }
}

