/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.GenericPropertiesConverter;
import io.crate.analyze.TableParameter;
import io.crate.analyze.TableParameters;
import io.crate.sql.tree.GenericProperties;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.Setting;

public final class TablePropertiesAnalyzer {
    private static final String INVALID_MESSAGE = "Invalid property \"%s\" passed to [ALTER | CREATE] TABLE statement";

    private TablePropertiesAnalyzer() {
    }

    public static void analyzeWithBoundValues(TableParameter tableParameter, TableParameters tableParameters, GenericProperties<Object> properties, boolean withDefaults) {
        Map<String, Setting<?>> settingMap = tableParameters.supportedSettings();
        Map<String, Setting<?>> mappingsMap = tableParameters.supportedMappings();
        GenericPropertiesConverter.settingsFromProperties(tableParameter.settingsBuilder(), properties, settingMap, withDefaults, mappingsMap::containsKey, INVALID_MESSAGE);
        GenericPropertiesConverter.settingsFromProperties(tableParameter.mappingsBuilder(), properties, mappingsMap, withDefaults, settingMap::containsKey, INVALID_MESSAGE);
    }

    public static void analyzeResetProperties(TableParameter tableParameter, TableParameters tableParameters, List<String> properties) {
        Map<String, Setting<?>> settingMap = tableParameters.supportedSettings();
        Map<String, Setting<?>> mappingsMap = tableParameters.supportedMappings();
        GenericPropertiesConverter.resetSettingsFromProperties(tableParameter.settingsBuilder(), properties, settingMap, mappingsMap::containsKey, INVALID_MESSAGE);
        GenericPropertiesConverter.resetSettingsFromProperties(tableParameter.mappingsBuilder(), properties, mappingsMap, settingMap::containsKey, INVALID_MESSAGE);
    }
}

