/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.blob.v2.BlobIndicesService;
import io.crate.common.collections.MapBuilder;
import io.crate.common.unit.TimeValue;
import io.crate.metadata.settings.NumberOfReplicasSetting;
import io.crate.metadata.settings.Validators;
import io.crate.metadata.table.ColumnPolicies;
import io.crate.sql.tree.ColumnPolicy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.MaxRetryAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.mapper.MapperService;

@Immutable
@ThreadSafe
public class TableParameters {
    static final NumberOfReplicasSetting NUMBER_OF_REPLICAS = new NumberOfReplicasSetting();
    static final Setting<String> COLUMN_POLICY = new Setting<String>((Setting.Key)new Setting.SimpleKey("dynamic"), s -> ColumnPolicy.STRICT.lowerCaseName(), s -> ColumnPolicies.encodeMappingValue(ColumnPolicy.of(s)), o -> {
        if (ColumnPolicies.encodeMappingValue(ColumnPolicy.IGNORED).equals(o)) {
            throw new IllegalArgumentException("Invalid value for argument 'column_policy'");
        }
    }, Setting.Property.IndexScope);
    private static final List<Setting<?>> SUPPORTED_SETTINGS = List.of(NUMBER_OF_REPLICAS, IndexSettings.INDEX_REFRESH_INTERVAL_SETTING, IndexMetadata.INDEX_READ_ONLY_SETTING, IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING, IndexMetadata.INDEX_BLOCKS_READ_SETTING, IndexMetadata.INDEX_BLOCKS_WRITE_SETTING, IndexMetadata.INDEX_BLOCKS_METADATA_SETTING, IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING, EnableAllocationDecider.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING, IndexSettings.INDEX_TRANSLOG_SYNC_INTERVAL_SETTING, IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING, ShardsLimitAllocationDecider.INDEX_TOTAL_SHARDS_PER_NODE_SETTING, MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING, IndexSettings.INDEX_WARMER_ENABLED_SETTING, UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING, IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS, MaxRetryAllocationDecider.SETTING_ALLOCATION_MAX_RETRY, IndexSettings.MAX_NGRAM_DIFF_SETTING, IndexSettings.MAX_SHINGLE_DIFF_SETTING, IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING, IndexMetadata.INDEX_ROUTING_REQUIRE_GROUP_SETTING, IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING, IndexMetadata.INDEX_ROUTING_EXCLUDE_GROUP_SETTING, EngineConfig.INDEX_CODEC_SETTING, IndexModule.INDEX_STORE_TYPE_SETTING, MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING, IndexSettings.INDEX_SOFT_DELETES_SETTING, IndexSettings.INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING, IndexService.GLOBAL_CHECKPOINT_SYNC_INTERVAL_SETTING, IndexService.RETENTION_LEASE_SYNC_INTERVAL_SETTING, IndexSettings.FILE_BASED_RECOVERY_THRESHOLD_SETTING);
    static final Set<Setting> SETTINGS_NOT_INCLUDED_IN_DEFAULT = Set.of(IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING, IndexSettings.INDEX_WARMER_ENABLED_SETTING, IndexService.GLOBAL_CHECKPOINT_SYNC_INTERVAL_SETTING, MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING, IndexSettings.INDEX_SOFT_DELETES_SETTING, IndexSettings.INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING, IndexService.RETENTION_LEASE_SYNC_INTERVAL_SETTING, IndexSettings.INDEX_REFRESH_INTERVAL_SETTING, IndexSettings.FILE_BASED_RECOVERY_THRESHOLD_SETTING);
    private static final Map<String, Setting<?>> SUPPORTED_SETTINGS_DEFAULT = SUPPORTED_SETTINGS.stream().collect(Collectors.toMap(s -> TableParameters.stripDotSuffix(TableParameters.stripIndexPrefix(s.getKey())), s -> s));
    private static final Set<Setting<?>> EXCLUDED_SETTING_FOR_METADATA_IMPORT = Set.of(NUMBER_OF_REPLICAS);
    private static final Map<String, Setting<?>> SUPPORTED_SETTINGS_INCL_SHARDS = MapBuilder.newMapBuilder(SUPPORTED_SETTINGS_DEFAULT).put(TableParameters.stripIndexPrefix(IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.getKey()), IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING).immutableMap();
    private static final Map<String, Setting<?>> SUPPORTED_MAPPINGS_DEFAULT = Map.of("column_policy", COLUMN_POLICY);
    public static final TableParameters TABLE_CREATE_PARAMETER_INFO = new TableParameters(SUPPORTED_SETTINGS_DEFAULT, SUPPORTED_MAPPINGS_DEFAULT);
    public static final TableParameters TABLE_ALTER_PARAMETER_INFO = new TableParameters(SUPPORTED_SETTINGS_INCL_SHARDS, SUPPORTED_MAPPINGS_DEFAULT);
    public static final TableParameters PARTITIONED_TABLE_PARAMETER_INFO_FOR_TEMPLATE_UPDATE = new TableParameters(SUPPORTED_SETTINGS_DEFAULT, Map.of());
    public static final TableParameters PARTITION_PARAMETER_INFO = new TableParameters(SUPPORTED_SETTINGS_INCL_SHARDS, Map.of());
    public static final TableParameters CREATE_BLOB_TABLE_PARAMETERS = new TableParameters(Map.of(NUMBER_OF_REPLICAS.getKey(), NUMBER_OF_REPLICAS, "blobs_path", Setting.simpleString(BlobIndicesService.SETTING_INDEX_BLOBS_PATH.getKey(), Validators.stringValidator("blobs_path", new String[0]), new Setting.Property[0])), Map.of());
    public static final TableParameters ALTER_BLOB_TABLE_PARAMETERS = new TableParameters(Map.of(NUMBER_OF_REPLICAS.getKey(), NUMBER_OF_REPLICAS), Map.of());
    private final Map<String, Setting<?>> supportedSettings;
    private final Map<String, Setting<?>> supportedMappings;

    protected TableParameters(Map<String, Setting<?>> supportedSettings, Map<String, Setting<?>> supportedMappings) {
        this.supportedSettings = supportedSettings;
        this.supportedMappings = supportedMappings;
    }

    public Map<String, Setting<?>> supportedSettings() {
        return this.supportedSettings;
    }

    public Map<String, Setting<?>> supportedMappings() {
        return this.supportedMappings;
    }

    public static String stripIndexPrefix(String key) {
        if (key.startsWith("index.")) {
            return key.substring("index.".length());
        }
        return key;
    }

    private static String stripDotSuffix(String key) {
        if (key.endsWith(".")) {
            return key.substring(0, key.length() - 1);
        }
        return key;
    }

    public static Map<String, Object> tableParametersFromIndexMetadata(Settings settings) {
        MapBuilder<String, Object> builder = MapBuilder.newMapBuilder();
        for (Setting<?> setting : SUPPORTED_SETTINGS) {
            boolean shouldBeExcluded = EXCLUDED_SETTING_FOR_METADATA_IMPORT.contains(setting);
            if (shouldBeExcluded) continue;
            if (setting instanceof Setting.AffixSetting) {
                TableParameters.flattenAffixSetting(builder, settings, (Setting.AffixSetting)setting);
                continue;
            }
            if (!settings.hasValue(setting.getKey())) continue;
            builder.put(setting.getKey(), TableParameters.convertEsSettingType(setting.get(settings)));
        }
        return builder.immutableMap();
    }

    private static void flattenAffixSetting(MapBuilder<String, Object> builder, Settings settings, Setting.AffixSetting<?> setting) {
        String prefix = setting.getKey();
        setting.getNamespaces(settings).forEach(s -> builder.put(prefix + s, setting.getConcreteSetting(prefix + s).get(settings)));
    }

    private static Object convertEsSettingType(Object value) {
        if (value instanceof Number || value instanceof Boolean) {
            return value;
        }
        if (value instanceof ByteSizeValue) {
            return ((ByteSizeValue)value).getBytes();
        }
        if (value instanceof TimeValue) {
            return ((TimeValue)value).getMillis();
        }
        return value.toString();
    }
}

