/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedColumnDefinition;
import io.crate.analyze.AnalyzedTableElements;
import io.crate.expression.symbol.Literal;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.AddColumnDefinition;
import io.crate.sql.tree.CheckColumnConstraint;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.CollectionColumnType;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.ColumnStorageDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.DefaultTraversalVisitor;
import io.crate.sql.tree.DropCheckConstraint;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.IndexColumnConstraint;
import io.crate.sql.tree.IndexDefinition;
import io.crate.sql.tree.NotNullColumnConstraint;
import io.crate.sql.tree.ObjectColumnType;
import io.crate.sql.tree.PrimaryKeyColumnConstraint;
import io.crate.sql.tree.PrimaryKeyConstraint;
import io.crate.sql.tree.TableElement;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class TableElementsAnalyzer {
    public static <T> AnalyzedTableElements<T> analyze(List<TableElement<T>> tableElements, RelationName relationName, @Nullable TableInfo tableInfo) {
        return TableElementsAnalyzer.analyze(tableElements, relationName, tableInfo, true);
    }

    public static <T> AnalyzedTableElements<T> analyze(List<TableElement<T>> tableElements, RelationName relationName, @Nullable TableInfo tableInfo, boolean logWarnings) {
        AnalyzedTableElements analyzedTableElements = new AnalyzedTableElements();
        int positionOffset = tableInfo == null ? 0 : tableInfo.columns().size();
        InnerTableElementsAnalyzer analyzer = new InnerTableElementsAnalyzer();
        for (int i = 0; i < tableElements.size(); ++i) {
            TableElement<T> tableElement = tableElements.get(i);
            int position = positionOffset + i + 1;
            ColumnDefinitionContext ctx = new ColumnDefinitionContext(position, null, analyzedTableElements, relationName, tableInfo, logWarnings);
            tableElement.accept(analyzer, ctx);
            if (ctx.analyzedColumnDefinition.ident() == null) continue;
            analyzedTableElements.add(ctx.analyzedColumnDefinition);
        }
        return analyzedTableElements;
    }

    private static class InnerTableElementsAnalyzer<T>
    extends DefaultTraversalVisitor<Void, ColumnDefinitionContext<T>> {
        private InnerTableElementsAnalyzer() {
        }

        @Override
        public Void visitColumnDefinition(ColumnDefinition<?> node, ColumnDefinitionContext<T> context) {
            ColumnDefinition<?> columnDefinition = node;
            context.analyzedColumnDefinition.name(node.ident());
            for (ColumnConstraint<?> columnConstraint : columnDefinition.constraints()) {
                columnConstraint.accept(this, context);
            }
            ColumnType<?> type = columnDefinition.type();
            if (type != null) {
                type.accept(this, context);
            }
            context.analyzedColumnDefinition.setGenerated(columnDefinition.isGenerated());
            if (columnDefinition.defaultExpression() != null) {
                context.analyzedColumnDefinition.defaultExpression(columnDefinition.defaultExpression());
            }
            if (columnDefinition.generatedExpression() != null) {
                context.analyzedColumnDefinition.generatedExpression(columnDefinition.generatedExpression());
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Void visitAddColumnDefinition(AddColumnDefinition<?> node, ColumnDefinitionContext<T> context) {
            AddColumnDefinition<?> addColumnDefinition = node;
            assert (addColumnDefinition.name() instanceof Literal) : "column name is expected to be a literal already";
            ColumnIdent column = ColumnIdent.fromPath(((Literal)addColumnDefinition.name()).value().toString());
            context.analyzedColumnDefinition.name(column.name());
            assert (context.tableInfo != null) : "Table must be available for `addColumnDefinition`";
            assert (context.analyzedTableElements.columns().size() == 0) : "context.analyzedTableElements.columns().size() must be 0";
            AnalyzedColumnDefinition root = context.analyzedColumnDefinition;
            if (!column.path().isEmpty()) {
                void var7_8;
                AnalyzedColumnDefinition parent = context.analyzedColumnDefinition;
                AnalyzedColumnDefinition analyzedColumnDefinition = parent;
                for (String name : column.path()) {
                    parent.dataType("object");
                    Reference parentRef = context.tableInfo.getReference(parent.ident());
                    if (parentRef != null) {
                        Integer n = parent.position = parentRef.column().isTopLevel() ? parentRef.position() : null;
                        if (parentRef.valueType().id() == 100) {
                            parent.collectionType("array");
                        } else {
                            parent.objectType(parentRef.columnPolicy());
                        }
                    }
                    parent.markAsParentColumn();
                    AnalyzedColumnDefinition analyzedColumnDefinition2 = new AnalyzedColumnDefinition(null, parent);
                    analyzedColumnDefinition2.name(name);
                    parent.addChild(analyzedColumnDefinition2);
                    parent = analyzedColumnDefinition2;
                }
                context.analyzedColumnDefinition = var7_8;
            }
            for (ColumnConstraint columnConstraint : addColumnDefinition.constraints()) {
                columnConstraint.accept(this, context);
            }
            ColumnType<?> type = node.type();
            if (type != null) {
                type.accept(this, context);
            }
            context.analyzedColumnDefinition.setGenerated(addColumnDefinition.isGenerated());
            if (addColumnDefinition.generatedExpression() != null) {
                context.analyzedColumnDefinition.generatedExpression(addColumnDefinition.generatedExpression());
            }
            context.analyzedColumnDefinition = root;
            return null;
        }

        @Override
        public Void visitColumnType(ColumnType<?> node, ColumnDefinitionContext<T> context) {
            context.analyzedColumnDefinition.dataType(node.name(), node.parameters(), context.logWarnings);
            return null;
        }

        @Override
        public Void visitObjectColumnType(ObjectColumnType<?> node, ColumnDefinitionContext<T> context) {
            ObjectColumnType<?> objectColumnType = node;
            context.analyzedColumnDefinition.dataType(objectColumnType.name());
            context.analyzedColumnDefinition.objectType(objectColumnType.objectType().orElse(ColumnPolicy.DYNAMIC));
            for (int i = 0; i < objectColumnType.nestedColumns().size(); ++i) {
                ColumnDefinition<?> columnDefinition = objectColumnType.nestedColumns().get(i);
                ColumnDefinitionContext childContext = new ColumnDefinitionContext(null, context.analyzedColumnDefinition, context.analyzedTableElements, context.relationName, context.tableInfo, context.logWarnings);
                columnDefinition.accept(this, childContext);
                context.analyzedColumnDefinition.addChild(childContext.analyzedColumnDefinition);
            }
            return null;
        }

        @Override
        public Void visitCollectionColumnType(CollectionColumnType<?> node, ColumnDefinitionContext<T> context) {
            context.analyzedColumnDefinition.collectionType("array");
            if (node.innerType() instanceof CollectionColumnType) {
                throw new UnsupportedOperationException("Nesting ARRAY or SET types is not supported");
            }
            node.innerType().accept(this, context);
            return null;
        }

        @Override
        public Void visitPrimaryKeyColumnConstraint(PrimaryKeyColumnConstraint<?> node, ColumnDefinitionContext<T> context) {
            context.analyzedColumnDefinition.setPrimaryKeyConstraint();
            return null;
        }

        @Override
        public Void visitPrimaryKeyConstraint(PrimaryKeyConstraint<?> node, ColumnDefinitionContext<T> context) {
            PrimaryKeyConstraint<?> primaryKeyConstraint = node;
            for (Object name : primaryKeyConstraint.columns()) {
                context.analyzedTableElements.addPrimaryKey(name);
            }
            return null;
        }

        @Override
        public Void visitCheckConstraint(CheckConstraint<?> node, ColumnDefinitionContext<T> context) {
            context.analyzedTableElements.addCheckConstraint(context.relationName, node);
            return null;
        }

        @Override
        public Void visitCheckColumnConstraint(CheckColumnConstraint<?> node, ColumnDefinitionContext<T> context) {
            context.analyzedTableElements.addCheckColumnConstraint(context.relationName, node);
            return null;
        }

        @Override
        public Void visitDropCheckConstraint(DropCheckConstraint<?> node, ColumnDefinitionContext<T> context) {
            return null;
        }

        @Override
        public Void visitIndexColumnConstraint(IndexColumnConstraint<?> node, ColumnDefinitionContext<T> context) {
            if (node.indexMethod().equals("fulltext")) {
                this.setAnalyzer(node.properties(), context, node.indexMethod());
            } else if (node.indexMethod().equalsIgnoreCase("plain")) {
                context.analyzedColumnDefinition.indexConstraint(Reference.IndexType.NOT_ANALYZED);
            } else if (node.indexMethod().equalsIgnoreCase("OFF")) {
                context.analyzedColumnDefinition.indexConstraint(Reference.IndexType.NO);
            } else if (node.indexMethod().equals("quadtree") || node.indexMethod().equals("geohash")) {
                this.setGeoType(node.properties(), context, node.indexMethod());
            } else {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid index method \"%s\"", node.indexMethod()));
            }
            return null;
        }

        @Override
        public Void visitNotNullColumnConstraint(NotNullColumnConstraint<?> node, ColumnDefinitionContext<T> context) {
            context.analyzedColumnDefinition.setNotNullConstraint();
            return null;
        }

        @Override
        public Void visitIndexDefinition(IndexDefinition<?> node, ColumnDefinitionContext<T> context) {
            IndexDefinition<?> indexDefinition = node;
            context.analyzedColumnDefinition.setAsIndexColumn();
            context.analyzedColumnDefinition.dataType("string");
            context.analyzedColumnDefinition.name(indexDefinition.ident());
            this.setAnalyzer(indexDefinition.properties(), context, indexDefinition.method());
            for (Object symbol : indexDefinition.columns()) {
                context.analyzedTableElements.addCopyTo(symbol, indexDefinition.ident());
            }
            return null;
        }

        @Override
        public Void visitColumnStorageDefinition(ColumnStorageDefinition<?> node, ColumnDefinitionContext<T> context) {
            context.analyzedColumnDefinition.setStorageProperties(node.properties());
            return null;
        }

        private void setGeoType(GenericProperties<T> properties, ColumnDefinitionContext<T> context, String indexMethod) {
            context.analyzedColumnDefinition.geoTree(indexMethod);
            context.analyzedColumnDefinition.geoProperties(properties);
        }

        private void setAnalyzer(GenericProperties<T> properties, ColumnDefinitionContext<T> context, String indexMethod) {
            context.analyzedColumnDefinition.indexConstraint(Reference.IndexType.ANALYZED);
            T analyzerName = properties.get("analyzer");
            if (analyzerName == null) {
                context.analyzedColumnDefinition.indexMethod(indexMethod);
                return;
            }
            context.analyzedColumnDefinition.analyzer(analyzerName);
        }
    }

    private static class ColumnDefinitionContext<T> {
        AnalyzedColumnDefinition<T> analyzedColumnDefinition;
        final AnalyzedTableElements<T> analyzedTableElements;
        final RelationName relationName;
        @Nullable
        final TableInfo tableInfo;
        final boolean logWarnings;

        ColumnDefinitionContext(Integer position, @Nullable AnalyzedColumnDefinition<T> parent, AnalyzedTableElements<T> analyzedTableElements, RelationName relationName, @Nullable TableInfo tableInfo, boolean logWarnings) {
            this.analyzedColumnDefinition = new AnalyzedColumnDefinition<T>(position, parent);
            this.analyzedTableElements = analyzedTableElements;
            this.relationName = relationName;
            this.tableInfo = tableInfo;
            this.logWarnings = logWarnings;
        }
    }
}

