/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedSwapTable;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.auth.user.User;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Schemas;
import io.crate.metadata.SearchPath;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.SwapTable;
import java.util.HashMap;

public final class SwapTableAnalyzer {
    public static final String DROP_SOURCE = "drop_source";
    private final NodeContext nodeCtx;
    private final Schemas schemas;

    SwapTableAnalyzer(NodeContext nodeCtx, Schemas schemas) {
        this.nodeCtx = nodeCtx;
        this.schemas = schemas;
    }

    public AnalyzedSwapTable analyze(SwapTable<Expression> swapTable, CoordinatorTxnCtx txnCtx, ParamTypeHints typeHints) {
        Symbol dropSource;
        HashMap<String, Expression> properties = new HashMap<String, Expression>(swapTable.properties().properties());
        Expression dropSourceExpr = properties.remove(DROP_SOURCE);
        if (!properties.isEmpty()) {
            throw new IllegalArgumentException("Invalid options for ALTER CLUSTER SWAP TABLE: " + String.join((CharSequence)", ", properties.keySet()));
        }
        if (dropSourceExpr == null) {
            dropSource = Literal.BOOLEAN_FALSE;
        } else {
            ExpressionAnalyzer exprAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, FieldProvider.UNSUPPORTED, null);
            dropSource = exprAnalyzer.convert(dropSourceExpr, new ExpressionAnalysisContext());
        }
        SearchPath searchPath = txnCtx.sessionContext().searchPath();
        User user = txnCtx.sessionContext().sessionUser();
        return new AnalyzedSwapTable((DocTableInfo)this.schemas.resolveTableInfo(swapTable.source(), Operation.ALTER, user, searchPath), (DocTableInfo)this.schemas.resolveTableInfo(swapTable.target(), Operation.ALTER, user, searchPath), dropSource);
    }
}

