/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.SubscriptContext;
import io.crate.sql.tree.ArrayLiteral;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Cast;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.FunctionCall;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.NegativeExpression;
import io.crate.sql.tree.ObjectLiteral;
import io.crate.sql.tree.ParameterExpression;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.StringLiteral;
import io.crate.sql.tree.SubqueryExpression;
import io.crate.sql.tree.SubscriptExpression;
import io.crate.sql.tree.TryCast;
import java.util.Locale;

public final class SubscriptValidator {
    private static final Long MAX_VALUE = 0x80000000L;

    private SubscriptValidator() {
    }

    public static void validate(SubscriptExpression node, SubscriptContext subscriptContext) {
        node.accept(SubscriptNameVisitor.INSTANCE, subscriptContext);
    }

    private static class SubscriptNameVisitor
    extends AstVisitor<Void, SubscriptContext> {
        private static final SubscriptNameVisitor INSTANCE = new SubscriptNameVisitor();

        private SubscriptNameVisitor() {
        }

        @Override
        protected Void visitSubscriptExpression(SubscriptExpression node, SubscriptContext context) {
            node.index().accept(SubscriptIndexVisitor.INSTANCE, context);
            node.base().accept(this, context);
            return null;
        }

        @Override
        protected Void visitQualifiedNameReference(QualifiedNameReference node, SubscriptContext context) {
            context.qualifiedName(node.getName());
            return null;
        }

        @Override
        public Void visitArrayLiteral(ArrayLiteral node, SubscriptContext context) {
            context.expression(node);
            return null;
        }

        @Override
        public Void visitObjectLiteral(ObjectLiteral node, SubscriptContext context) {
            context.expression(node);
            return null;
        }

        @Override
        protected Void visitCast(Cast node, SubscriptContext context) {
            context.expression(node);
            return null;
        }

        @Override
        protected Void visitTryCast(TryCast node, SubscriptContext context) {
            context.expression(node);
            return null;
        }

        @Override
        protected Void visitFunctionCall(FunctionCall node, SubscriptContext context) {
            context.expression(node);
            return null;
        }

        @Override
        protected Void visitSubqueryExpression(SubqueryExpression node, SubscriptContext context) {
            context.expression(node);
            return null;
        }

        @Override
        protected Void visitExpression(Expression node, SubscriptContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "An expression of type %s cannot have an index accessor ([])", node.getClass().getSimpleName()));
        }
    }

    private static class SubscriptIndexVisitor
    extends AstVisitor<Void, SubscriptContext> {
        private static final SubscriptIndexVisitor INSTANCE = new SubscriptIndexVisitor();

        private SubscriptIndexVisitor() {
        }

        private static void raiseInvalidIndexValue() {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Array index must be in range 1 to %s", MAX_VALUE));
        }

        @Override
        public Void visitParameterExpression(ParameterExpression node, SubscriptContext context) {
            throw new UnsupportedOperationException("Parameter substitution is not supported in subscript index");
        }

        @Override
        protected Void visitStringLiteral(StringLiteral node, SubscriptContext context) {
            this.validateNestedArrayAccess(context);
            context.add(node.getValue());
            return null;
        }

        @Override
        protected Void visitLongLiteral(LongLiteral node, SubscriptContext context) {
            this.validateNestedArrayAccess(context);
            long value = node.getValue();
            if (value < 1L || value > MAX_VALUE) {
                SubscriptIndexVisitor.raiseInvalidIndexValue();
            }
            context.index(new Cast(node, new ColumnType("integer")));
            return null;
        }

        @Override
        protected Void visitIntegerLiteral(IntegerLiteral node, SubscriptContext context) {
            this.validateNestedArrayAccess(context);
            if (node.getValue() < 1) {
                SubscriptIndexVisitor.raiseInvalidIndexValue();
            }
            context.index(new Cast(node, new ColumnType("integer")));
            return null;
        }

        @Override
        protected Void visitNegativeExpression(NegativeExpression node, SubscriptContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Array index must be in range 1 to %s", MAX_VALUE));
        }

        @Override
        protected Void visitExpression(Expression node, SubscriptContext context) {
            context.index(node);
            return null;
        }

        private void validateNestedArrayAccess(SubscriptContext context) {
            if (context.index() != null) {
                throw new UnsupportedOperationException("Nested array access is not supported");
            }
        }
    }
}

