/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.Analysis;
import io.crate.analyze.AnalyzedShowCreateTable;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.Analyzer;
import io.crate.auth.user.User;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.metadata.table.Operation;
import io.crate.sql.ExpressionFormatter;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.ShowColumns;
import io.crate.sql.tree.ShowSchemas;
import io.crate.sql.tree.ShowSessionParameter;
import io.crate.sql.tree.ShowTables;
import io.crate.sql.tree.Table;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;

class ShowStatementAnalyzer {
    private final Analyzer analyzer;
    private final String[] explicitSchemas = new String[]{"information_schema", "sys", "pg_catalog"};
    private final Schemas schemas;
    private final SessionSettingRegistry sessionSettingRegistry;

    ShowStatementAnalyzer(Analyzer analyzer, Schemas schemas, SessionSettingRegistry sessionSettingRegistry) {
        this.analyzer = analyzer;
        this.schemas = schemas;
        this.sessionSettingRegistry = sessionSettingRegistry;
    }

    Query rewriteShowTransaction() {
        return (Query)SqlParser.createStatement("select 'read uncommitted' as transaction_isolation from sys.cluster");
    }

    AnalyzedStatement analyzeShowTransaction(Analysis analysis) {
        return this.unboundAnalyze(this.rewriteShowTransaction(), analysis);
    }

    public AnalyzedStatement analyzeShowCreateTable(Table table, Analysis analysis) {
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.resolveTableInfo(table.getName(), Operation.SHOW_CREATE, User.CRATE_USER, analysis.sessionContext().searchPath());
        return new AnalyzedShowCreateTable(tableInfo);
    }

    Query rewriteShowSessionParameter(ShowSessionParameter node) {
        StringBuilder sb = new StringBuilder("SELECT ");
        QualifiedName sessionSetting = node.parameter();
        if (sessionSetting != null) {
            sb.append("setting ");
        } else {
            sb.append("name, setting, short_desc as description ");
        }
        sb.append("FROM pg_catalog.pg_settings ");
        if (sessionSetting != null) {
            sb.append("WHERE name = ");
            ShowStatementAnalyzer.singleQuote(sb, sessionSetting.toString());
        }
        return (Query)SqlParser.createStatement(sb.toString());
    }

    void validateSessionSetting(@Nullable QualifiedName settingParameter) {
        if (settingParameter != null && !this.sessionSettingRegistry.settings().containsKey(settingParameter.toString())) {
            throw new IllegalArgumentException("Unknown session setting name '" + settingParameter + "'.");
        }
    }

    Query rewriteShowSchemas(ShowSchemas node) {
        StringBuilder sb = new StringBuilder("SELECT schema_name ");
        sb.append("FROM information_schema.schemata ");
        String likePattern = node.likePattern();
        if (likePattern != null) {
            sb.append("WHERE schema_name LIKE ");
            ShowStatementAnalyzer.singleQuote(sb, likePattern);
        } else if (node.whereExpression().isPresent()) {
            sb.append(String.format(Locale.ENGLISH, "WHERE %s ", node.whereExpression().get().toString()));
        }
        sb.append("ORDER BY schema_name");
        return (Query)SqlParser.createStatement(sb.toString());
    }

    Query rewriteShowColumns(ShowColumns node, String defaultSchema) {
        StringBuilder sb = new StringBuilder("SELECT column_name, data_type FROM information_schema.columns ");
        sb.append("WHERE table_name = ");
        ShowStatementAnalyzer.singleQuote(sb, node.table().toString());
        sb.append("AND table_schema = ");
        QualifiedName schema = node.schema();
        if (schema != null) {
            ShowStatementAnalyzer.singleQuote(sb, schema.toString());
        } else {
            ShowStatementAnalyzer.singleQuote(sb, defaultSchema);
        }
        String likePattern = node.likePattern();
        if (likePattern != null) {
            sb.append("AND column_name LIKE ");
            ShowStatementAnalyzer.singleQuote(sb, likePattern);
        } else if (node.where().isPresent()) {
            sb.append(String.format(Locale.ENGLISH, "AND %s", ExpressionFormatter.formatExpression(node.where().get())));
        }
        sb.append("ORDER BY column_name");
        return (Query)SqlParser.createStatement(sb.toString());
    }

    private AnalyzedStatement unboundAnalyze(Query query, Analysis analysis) {
        return this.analyzer.analyze(query, analysis.sessionContext(), analysis.paramTypeHints());
    }

    public Query rewriteShowTables(ShowTables node) {
        StringBuilder sb = new StringBuilder("SELECT distinct(table_name) as table_name FROM information_schema.tables WHERE table_type = 'BASE TABLE' ");
        QualifiedName schema = node.schema();
        if (schema != null) {
            sb.append("AND table_schema = ");
            ShowStatementAnalyzer.singleQuote(sb, schema.toString());
        } else {
            sb.append("AND table_schema NOT IN (");
            for (int i = 0; i < this.explicitSchemas.length; ++i) {
                ShowStatementAnalyzer.singleQuote(sb, this.explicitSchemas[i]);
                if (i >= this.explicitSchemas.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        Optional<Expression> whereExpression = node.whereExpression();
        if (whereExpression.isPresent()) {
            sb.append(" AND (");
            sb.append(whereExpression.get().toString());
            sb.append(")");
        } else {
            String likePattern = node.likePattern();
            if (likePattern != null) {
                sb.append(" AND table_name like ");
                ShowStatementAnalyzer.singleQuote(sb, likePattern);
            }
        }
        sb.append(" ORDER BY 1");
        return (Query)SqlParser.createStatement(sb.toString());
    }

    private static void singleQuote(StringBuilder builder, String string) {
        builder.append("'").append(string).append("'");
    }
}

