/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedSetLicenseStatement;
import io.crate.analyze.AnalyzedSetStatement;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.SetStatement;

class SetStatementAnalyzer {
    private final NodeContext nodeCtx;

    SetStatementAnalyzer(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedStatement analyze(SetStatement<Expression> node, ParamTypeHints typeHints, CoordinatorTxnCtx txnCtx) {
        boolean isPersistent = node.settingType().equals((Object)SetStatement.SettingType.PERSISTENT);
        ExpressionAnalyzer exprAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, FieldProvider.FIELDS_AS_LITERAL, null);
        SetStatement<Symbol> statement = node.map(x -> exprAnalyzer.convert((Expression)x, new ExpressionAnalysisContext()));
        if (node.scope() == SetStatement.Scope.LICENSE) {
            if (node.assignments().size() != 1) {
                throw new IllegalArgumentException("Invalid number of arguments for SET LICENSE. Please provide only the license key");
            }
            return new AnalyzedSetLicenseStatement(statement.assignments().get(0).expression());
        }
        return new AnalyzedSetStatement(node.scope(), statement.assignments(), isPersistent);
    }
}

