/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.expression.operator.Operators;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.Reference;
import io.crate.types.DataTypes;
import java.util.ArrayList;

public final class ScalarsAndRefsToTrue
extends SymbolVisitor<Void, Symbol> {
    private static final ScalarsAndRefsToTrue INSTANCE = new ScalarsAndRefsToTrue();

    private ScalarsAndRefsToTrue() {
    }

    public static Symbol rewrite(Symbol symbol) {
        return symbol.accept(INSTANCE, null);
    }

    @Override
    public Symbol visitFunction(Function symbol, Void context) {
        String functionName = symbol.name();
        if (functionName.equals("op_not")) {
            Symbol argument = symbol.arguments().get(0);
            if (argument instanceof Reference) {
                return argument.accept(this, context);
            }
            if (argument instanceof Function && !Operators.LOGICAL_OPERATORS.contains(((Function)argument).name())) {
                return argument.accept(this, context);
            }
        }
        ArrayList<Symbol> newArgs = new ArrayList<Symbol>(symbol.arguments().size());
        boolean allLiterals = true;
        boolean isNull = false;
        for (Symbol arg : symbol.arguments()) {
            Symbol processedArg = arg.accept(this, context);
            newArgs.add(processedArg);
            if (!processedArg.symbolType().isValueSymbol()) {
                allLiterals = false;
            }
            if (processedArg.valueType().id() != DataTypes.UNDEFINED.id()) continue;
            isNull = true;
        }
        if (allLiterals && !Operators.LOGICAL_OPERATORS.contains(functionName)) {
            return isNull ? Literal.NULL : Literal.BOOLEAN_TRUE;
        }
        return new Function(symbol.signature(), newArgs, symbol.valueType());
    }

    @Override
    public Symbol visitMatchPredicate(MatchPredicate matchPredicate, Void context) {
        return Literal.BOOLEAN_TRUE;
    }

    @Override
    protected Symbol visitSymbol(Symbol symbol, Void context) {
        if (symbol.valueType().id() == DataTypes.UNDEFINED.id()) {
            return Literal.NULL;
        }
        return Literal.BOOLEAN_TRUE;
    }

    @Override
    public Symbol visitLiteral(Literal symbol, Void context) {
        return symbol;
    }
}

