/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedRestoreSnapshot;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.common.collections.Lists2;
import io.crate.execution.ddl.RepositoryService;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.RestoreSnapshot;
import io.crate.sql.tree.Table;
import java.util.List;

class RestoreSnapshotAnalyzer {
    private final RepositoryService repositoryService;
    private final NodeContext nodeCtx;

    RestoreSnapshotAnalyzer(RepositoryService repositoryService, NodeContext nodeCtx) {
        this.repositoryService = repositoryService;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedRestoreSnapshot analyze(RestoreSnapshot<Expression> restoreSnapshot, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        List<String> nameParts = restoreSnapshot.name().getParts();
        if (nameParts.size() != 2) {
            throw new IllegalArgumentException("Snapshot name not supported, only <repository>.<snapshot> works.)");
        }
        String repositoryName = nameParts.get(0);
        String snapshotName = nameParts.get(1);
        this.repositoryService.failIfRepositoryDoesNotExist(repositoryName);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
        ExpressionAnalyzer exprAnalyzerWithoutFields = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.UNSUPPORTED, null);
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.FIELDS_AS_LITERAL, null);
        List<Table<Symbol>> tables = Lists2.map(restoreSnapshot.tables(), table -> table.map(x -> exprAnalyzerWithFieldsAsString.convert((Expression)x, exprCtx)));
        GenericProperties<Symbol> properties = restoreSnapshot.properties().map(x -> exprAnalyzerWithoutFields.convert((Expression)x, exprCtx));
        return new AnalyzedRestoreSnapshot(repositoryName, snapshotName, tables, properties);
    }
}

