/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.OrderBy;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.analyze.relations.JoinPair;
import io.crate.common.collections.Lists2;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QueriedSelectRelation
implements AnalyzedRelation {
    private final List<AnalyzedRelation> from;
    private final List<JoinPair> joinPairs;
    private final boolean isDistinct;
    private final List<Symbol> outputs;
    private final Symbol whereClause;
    private final List<Symbol> groupBy;
    @Nullable
    private final Symbol having;
    @Nullable
    private final OrderBy orderBy;
    @Nullable
    private final Symbol offset;
    @Nullable
    private final Symbol limit;

    public QueriedSelectRelation(boolean isDistinct, List<AnalyzedRelation> from, List<JoinPair> joinPairs, List<Symbol> outputs, Symbol whereClause, List<Symbol> groupBy, @Nullable Symbol having, @Nullable OrderBy orderBy, @Nullable Symbol limit, @Nullable Symbol offset) {
        this.outputs = outputs;
        this.whereClause = whereClause;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
        this.offset = offset;
        this.limit = limit;
        assert (from.size() >= 1) : "QueriedSelectRelation must have at least 1 relation in FROM";
        this.isDistinct = isDistinct;
        this.from = from;
        this.joinPairs = joinPairs;
    }

    public List<AnalyzedRelation> from() {
        return this.from;
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation) throws UnsupportedOperationException, ColumnUnknownException {
        Symbol match = null;
        for (Symbol output : this.outputs()) {
            ColumnIdent outputName = Symbols.pathFromSymbol(output);
            if (!outputName.equals(column)) continue;
            if (match != null) {
                throw new AmbiguousColumnException(column, output);
            }
            match = output;
        }
        if (match == null) {
            for (AnalyzedRelation analyzedRelation : this.from) {
                Symbol field = analyzedRelation.getField(column, operation);
                if (field == null) continue;
                if (match != null) {
                    throw new AmbiguousColumnException(column, field);
                }
                match = field;
            }
        }
        return match;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitQueriedSelectRelation(this, context);
    }

    @Override
    public RelationName relationName() {
        throw new UnsupportedOperationException("QueriedSelectRelation has no name. It must be beneath an aliased-relation to be addressable by name");
    }

    @Override
    @Nonnull
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public Symbol where() {
        return this.whereClause;
    }

    public List<Symbol> groupBy() {
        return this.groupBy;
    }

    @Nullable
    public Symbol having() {
        return this.having;
    }

    @Nullable
    public OrderBy orderBy() {
        return this.orderBy;
    }

    @Nullable
    public Symbol limit() {
        return this.limit;
    }

    @Nullable
    public Symbol offset() {
        return this.offset;
    }

    public String toString() {
        return "SELECT " + Lists2.joinOn(", ", this.outputs(), x -> Symbols.pathFromSymbol(x).sqlFqn()) + " FROM (" + Lists2.joinOn(", ", this.from, x -> x.relationName().toString()) + ")";
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Symbol output : this.outputs) {
            consumer.accept(output);
        }
        consumer.accept(this.whereClause);
        for (Symbol groupKey : this.groupBy) {
            consumer.accept(groupKey);
        }
        if (this.having != null) {
            consumer.accept(this.having);
        }
        if (this.orderBy != null) {
            this.orderBy.accept(consumer);
        }
        if (this.limit != null) {
            consumer.accept(this.limit);
        }
        if (this.offset != null) {
            consumer.accept(this.offset);
        }
        for (JoinPair joinPair : this.joinPairs) {
            if (joinPair.condition() == null) continue;
            consumer.accept(joinPair.condition());
        }
    }

    public List<JoinPair> joinPairs() {
        return this.joinPairs;
    }
}

