/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedPrivileges;
import io.crate.analyze.user.Privilege;
import io.crate.auth.user.User;
import io.crate.common.collections.Lists2;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.SearchPath;
import io.crate.sql.tree.DenyPrivilege;
import io.crate.sql.tree.GrantPrivilege;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.RevokePrivilege;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

class PrivilegesAnalyzer {
    private final boolean userManagementEnabled;
    private final Schemas schemas;
    private static final String ERROR_MESSAGE = "GRANT/DENY/REVOKE Privileges on information_schema is not supported";

    PrivilegesAnalyzer(boolean userManagementEnabled, Schemas schemas) {
        this.userManagementEnabled = userManagementEnabled;
        this.schemas = schemas;
    }

    AnalyzedPrivileges analyzeGrant(GrantPrivilege node, User user, SearchPath searchPath) {
        this.ensureUserManagementEnabled();
        Privilege.Clazz clazz = Privilege.Clazz.valueOf(node.clazz());
        List<String> idents = this.validatePrivilegeIdents(clazz, node.privilegeIdents(), false, searchPath, this.schemas);
        return new AnalyzedPrivileges(node.userNames(), PrivilegesAnalyzer.privilegeTypesToPrivileges(PrivilegesAnalyzer.getPrivilegeTypes(node.all(), node.privileges()), user, Privilege.State.GRANT, idents, clazz));
    }

    AnalyzedPrivileges analyzeRevoke(RevokePrivilege node, User user, SearchPath searchPath) {
        this.ensureUserManagementEnabled();
        Privilege.Clazz clazz = Privilege.Clazz.valueOf(node.clazz());
        List<String> idents = this.validatePrivilegeIdents(clazz, node.privilegeIdents(), true, searchPath, this.schemas);
        return new AnalyzedPrivileges(node.userNames(), PrivilegesAnalyzer.privilegeTypesToPrivileges(PrivilegesAnalyzer.getPrivilegeTypes(node.all(), node.privileges()), user, Privilege.State.REVOKE, idents, clazz));
    }

    AnalyzedPrivileges analyzeDeny(DenyPrivilege node, User user, SearchPath searchPath) {
        this.ensureUserManagementEnabled();
        Privilege.Clazz clazz = Privilege.Clazz.valueOf(node.clazz());
        List<String> idents = this.validatePrivilegeIdents(clazz, node.privilegeIdents(), false, searchPath, this.schemas);
        return new AnalyzedPrivileges(node.userNames(), PrivilegesAnalyzer.privilegeTypesToPrivileges(PrivilegesAnalyzer.getPrivilegeTypes(node.all(), node.privileges()), user, Privilege.State.DENY, idents, clazz));
    }

    private void ensureUserManagementEnabled() {
        if (!this.userManagementEnabled) {
            throw new UnsupportedOperationException("User management is not enabled");
        }
    }

    private static Collection<Privilege.Type> getPrivilegeTypes(boolean all, List<String> typeNames) {
        List<Privilege.Type> privilegeTypes = all ? Privilege.Type.VALUES : PrivilegesAnalyzer.parsePrivilegeTypes(typeNames);
        return privilegeTypes;
    }

    private static void validateSchemaNames(List<String> schemaNames) {
        schemaNames.forEach(PrivilegesAnalyzer::validateSchemaName);
    }

    private static void validateSchemaName(String schemaName) {
        if ("information_schema".equals(schemaName)) {
            throw new UnsupportedFeatureException(ERROR_MESSAGE);
        }
    }

    private List<String> validatePrivilegeIdents(Privilege.Clazz clazz, List<QualifiedName> tableOrSchemaNames, boolean isRevoke, SearchPath searchPath, Schemas schemas) {
        if (Privilege.Clazz.SCHEMA.equals((Object)clazz)) {
            List<String> schemaNames = Lists2.map(tableOrSchemaNames, QualifiedName::toString);
            if (isRevoke) {
                return schemaNames;
            }
            PrivilegesAnalyzer.validateSchemaNames(schemaNames);
            return schemaNames;
        }
        return PrivilegesAnalyzer.resolveAndValidateRelations(tableOrSchemaNames, searchPath, schemas, isRevoke);
    }

    private static List<Privilege.Type> parsePrivilegeTypes(List<String> privilegeTypeNames) {
        ArrayList<Privilege.Type> privilegeTypes = new ArrayList<Privilege.Type>(privilegeTypeNames.size());
        for (String typeName : privilegeTypeNames) {
            Privilege.Type privilegeType;
            try {
                privilegeType = Privilege.Type.valueOf(typeName.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unknown privilege type '%s'", typeName));
            }
            if (!Privilege.Type.VALUES.contains((Object)privilegeType)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unknown privilege type '%s'", typeName));
            }
            privilegeTypes.add(privilegeType);
        }
        return privilegeTypes;
    }

    private static Set<Privilege> privilegeTypesToPrivileges(Collection<Privilege.Type> privilegeTypes, User grantor, Privilege.State state, List<String> idents, Privilege.Clazz clazz) {
        HashSet<Privilege> privileges = new HashSet<Privilege>(privilegeTypes.size());
        if (Privilege.Clazz.CLUSTER.equals((Object)clazz)) {
            for (Privilege.Type privilegeType : privilegeTypes) {
                Privilege privilege = new Privilege(state, privilegeType, clazz, null, grantor.name());
                privileges.add(privilege);
            }
        } else {
            for (Privilege.Type privilegeType : privilegeTypes) {
                for (String ident : idents) {
                    Privilege privilege = new Privilege(state, privilegeType, clazz, ident, grantor.name());
                    privileges.add(privilege);
                }
            }
        }
        return privileges;
    }

    private static List<String> resolveAndValidateRelations(List<QualifiedName> relations, SearchPath searchPath, Schemas schemas, boolean isRevoke) {
        return Lists2.map(relations, q -> {
            try {
                RelationName relationName = schemas.resolveRelation((QualifiedName)q, searchPath);
                if (!isRevoke) {
                    PrivilegesAnalyzer.validateSchemaName(relationName.schema());
                }
                return relationName.fqn();
            }
            catch (RelationUnknown e) {
                if (!isRevoke) {
                    throw e;
                }
                return RelationName.of(q, searchPath.currentSchema()).fqn();
            }
        });
    }
}

