/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.sql.tree.Assignment;
import io.crate.types.DataTypes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class PartitionPropertiesAnalyzer {
    public static Map<ColumnIdent, Object> assignmentsToMap(List<Assignment<Object>> assignments) {
        HashMap<ColumnIdent, Object> map = new HashMap<ColumnIdent, Object>(assignments.size());
        for (Assignment<Object> assignment : assignments) {
            map.put(ColumnIdent.fromPath(assignment.columnName().toString()), assignment.expression());
        }
        return map;
    }

    public static PartitionName toPartitionName(RelationName relationName, List<Assignment<Object>> partitionProperties) {
        Map<ColumnIdent, Object> properties = PartitionPropertiesAnalyzer.assignmentsToMap(partitionProperties);
        String[] values = new String[properties.size()];
        int idx = 0;
        for (Object o : properties.values()) {
            values[idx++] = DataTypes.STRING.implicitCast(o);
        }
        return new PartitionName(relationName, List.of(values));
    }

    public static PartitionName toPartitionName(DocTableInfo tableInfo, List<Assignment<Object>> partitionProperties) {
        if (!tableInfo.isPartitioned()) {
            throw new IllegalArgumentException("table '" + tableInfo.ident().fqn() + "' is not partitioned");
        }
        if (partitionProperties.size() != tableInfo.partitionedBy().size()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The table \"%s\" is partitioned by %s columns but the PARTITION clause contains %s columns", tableInfo.ident().fqn(), tableInfo.partitionedBy().size(), partitionProperties.size()));
        }
        Map<ColumnIdent, Object> properties = PartitionPropertiesAnalyzer.assignmentsToMap(partitionProperties);
        String[] values = new String[properties.size()];
        for (Map.Entry<ColumnIdent, Object> entry : properties.entrySet()) {
            Object value = entry.getValue();
            int idx = tableInfo.partitionedBy().indexOf(entry.getKey());
            try {
                Reference reference = tableInfo.partitionedByColumns().get(idx);
                Object converted = reference.valueType().implicitCast(value);
                values[idx] = DataTypes.STRING.implicitCast(converted);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "\"%s\" is no known partition column", entry.getKey().sqlFqn()));
            }
        }
        return new PartitionName(tableInfo.ident(), Arrays.asList(values));
    }

    @Nullable
    public static PartitionName createPartitionName(List<Assignment<Object>> partitionsProperties, DocTableInfo tableInfo) {
        if (partitionsProperties.isEmpty()) {
            return null;
        }
        PartitionName partitionName = PartitionPropertiesAnalyzer.toPartitionName(tableInfo, partitionsProperties);
        if (!tableInfo.partitions().contains(partitionName)) {
            throw new IllegalArgumentException("Referenced partition \"" + partitionName + "\" does not exist.");
        }
        return partitionName;
    }
}

