/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.sql.ExpressionFormatter;
import io.crate.sql.tree.ArrayComparisonExpression;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.SubqueryExpression;
import io.crate.sql.tree.SubscriptExpression;
import java.util.List;
import java.util.NoSuchElementException;

public class OutputNameFormatter {
    private static final InnerOutputNameFormatter INSTANCE = new InnerOutputNameFormatter();

    public static String format(Expression expression) {
        return expression.accept(INSTANCE, null);
    }

    private static class InnerOutputNameFormatter
    extends ExpressionFormatter.Formatter {
        private InnerOutputNameFormatter() {
        }

        @Override
        protected String visitQualifiedNameReference(QualifiedNameReference node, List<Expression> parameters) {
            List<String> parts = node.getName().getParts();
            if (parts.isEmpty()) {
                throw new NoSuchElementException("Parts of QualifiedNameReference are empty: " + node.getName());
            }
            return parts.get(parts.size() - 1);
        }

        @Override
        protected String visitSubscriptExpression(SubscriptExpression node, List<Expression> parameters) {
            return node.base().accept(this, null) + "[" + node.index().accept(this, null) + "]";
        }

        @Override
        public String visitArrayComparisonExpression(ArrayComparisonExpression node, List<Expression> parameters) {
            return node.getLeft().accept(this, null) + " " + node.getType().getValue() + " " + node.quantifier().name() + "(" + node.getRight().accept(this, null) + ")";
        }

        @Override
        protected String visitSubqueryExpression(SubqueryExpression node, List<Expression> parameters) {
            return super.visitSubqueryExpression(node, parameters).replace("\n", "");
        }
    }
}

