/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedOptimizeTable;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Schemas;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.OptimizeStatement;
import io.crate.sql.tree.Table;
import java.util.HashMap;

public class OptimizeTableAnalyzer {
    private final Schemas schemas;
    private final NodeContext nodeCtx;

    OptimizeTableAnalyzer(Schemas schemas, NodeContext nodeCtx) {
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedOptimizeTable analyze(OptimizeStatement<Expression> statement, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.FIELDS_AS_LITERAL, null);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext();
        OptimizeStatement<Symbol> analyzedStatement = statement.map(x -> exprAnalyzerWithFieldsAsString.convert((Expression)x, exprCtx));
        HashMap<Table<Symbol>, TableInfo> analyzedOptimizeTables = new HashMap<Table<Symbol>, TableInfo>();
        for (Table<Symbol> table : analyzedStatement.tables()) {
            TableInfo tableInfo = this.schemas.resolveTableInfo(table.getName(), Operation.OPTIMIZE, txnCtx.sessionContext().sessionUser(), txnCtx.sessionContext().searchPath());
            analyzedOptimizeTables.put(table, tableInfo);
        }
        return new AnalyzedOptimizeTable(analyzedOptimizeTables, analyzedStatement.properties());
    }
}

