/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.sql.tree.ClusteredBy;
import io.crate.types.DataTypes;
import java.util.Locale;
import java.util.Optional;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class NumberOfShards {
    private static final Integer MIN_NUM_SHARDS = 4;
    private final ClusterService clusterService;

    @Inject
    public NumberOfShards(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public int fromClusteredByClause(ClusteredBy<Object> clusteredBy) {
        Optional<Object> numberOfShards = clusteredBy.numberOfShards();
        return numberOfShards.map(rawNumOfShards -> {
            if (!(rawNumOfShards instanceof Number)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid number '%s'", rawNumOfShards));
            }
            Integer numShards = DataTypes.INTEGER.sanitizeValue(rawNumOfShards);
            if (numShards < 1) {
                throw new IllegalArgumentException("num_shards in CLUSTERED clause must be greater than 0");
            }
            return numShards;
        }).orElse(this.defaultNumberOfShards());
    }

    public int defaultNumberOfShards() {
        int numDataNodes = this.clusterService.state().nodes().getDataNodes().size();
        assert (numDataNodes >= 0) : "number of data nodes cannot be less than 0";
        return Math.max(MIN_NUM_SHARDS, numDataNodes * 2);
    }
}

