/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.common.Booleans;
import java.util.Objects;
import java.util.regex.Pattern;
import org.elasticsearch.cluster.metadata.AutoExpandReplicas;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Settings;

public class NumberOfReplicas {
    public static final String NUMBER_OF_REPLICAS = "index.number_of_replicas";
    public static final String AUTO_EXPAND_REPLICAS = "index.auto_expand_replicas";
    private static final Pattern EXPAND_REPLICA_PATTERN = Pattern.compile("\\d+\\-(all|\\d+)");
    private final String esSettingKey;
    private final String esSettingsValue;

    public NumberOfReplicas(Integer numReplicas) {
        this.esSettingKey = NUMBER_OF_REPLICAS;
        this.esSettingsValue = numReplicas.toString();
    }

    public NumberOfReplicas(String numReplicas) {
        assert (numReplicas != null) : "numReplicas must not be null";
        NumberOfReplicas.validateExpandReplicaSetting(numReplicas);
        this.esSettingKey = AUTO_EXPAND_REPLICAS;
        this.esSettingsValue = numReplicas;
    }

    private static void validateExpandReplicaSetting(String replicas) {
        if (!EXPAND_REPLICA_PATTERN.matcher(replicas).matches()) {
            throw new IllegalArgumentException("The \"number_of_replicas\" range \"" + replicas + "\" isn't valid");
        }
    }

    public String esSettingKey() {
        return this.esSettingKey;
    }

    public String esSettingValue() {
        return this.esSettingsValue;
    }

    public static String fromSettings(Settings settings) {
        String numberOfReplicas;
        String autoExpandReplicas = settings.get(AUTO_EXPAND_REPLICAS);
        if (autoExpandReplicas != null && !Booleans.isFalse(autoExpandReplicas)) {
            NumberOfReplicas.validateExpandReplicaSetting(autoExpandReplicas);
            numberOfReplicas = autoExpandReplicas;
        } else {
            numberOfReplicas = Objects.requireNonNullElse(settings.get(NUMBER_OF_REPLICAS), "1");
        }
        return numberOfReplicas;
    }

    public static int fromSettings(Settings settings, int dataNodeCount) {
        AutoExpandReplicas autoExpandReplicas = IndexMetadata.INDEX_AUTO_EXPAND_REPLICAS_SETTING.get(settings);
        if (autoExpandReplicas.isEnabled()) {
            int min = autoExpandReplicas.getMinReplicas();
            int max = autoExpandReplicas.getMaxReplicas(dataNodeCount);
            int numberOfReplicas = dataNodeCount - 1;
            if (numberOfReplicas < min) {
                return min;
            }
            if (numberOfReplicas > max) {
                return max;
            }
        }
        return IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(settings);
    }
}

