/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.types.DataType;

public final class NegateLiterals
extends SymbolVisitor<Void, Symbol> {
    private static final NegateLiterals INSTANCE = new NegateLiterals();

    private NegateLiterals() {
    }

    public static Symbol negate(Symbol symbol) {
        return symbol.accept(INSTANCE, null);
    }

    @Override
    public Literal visitLiteral(Literal symbol, Void context) {
        Object value = symbol.value();
        if (value == null) {
            return symbol;
        }
        DataType valueType = symbol.valueType();
        switch (valueType.id()) {
            case 6: {
                return Literal.of(valueType, (Double)value * -1.0);
            }
            case 7: {
                return Literal.of(valueType, (Double)value * -1.0);
            }
            case 8: {
                return Literal.of(valueType, (Short)value * -1);
            }
            case 9: {
                return Literal.of(valueType, (Integer)value * -1);
            }
            case 10: {
                return Literal.of(valueType, (Long)value * -1L);
            }
        }
        throw new UnsupportedOperationException(Symbols.format("Cannot negate %s. You may need to add explicit type casts", symbol));
    }
}

